/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.memberconfig;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.managementcenter.ConcurrentArrayRingbuffer;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.service.MembersConfigsParsedEvent;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.memberconfig.CacheCreator;
import com.hazelcast.webmonitor.service.memberconfig.ClusterSizeProvider;
import com.hazelcast.webmonitor.service.memberconfig.InstrumentedMemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigFactory;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.service.memberconfig.XmlParsingTimeListener;
import com.hazelcast.webmonitor.utils.MemberUtil;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class DefaultMemberConfigService
implements XmlParsingTimeListener,
MemberConfigService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMemberConfigService.class);
    private static final int RATE = 10;
    private static final Logger TASK_EXCEPTION_LOGGER = RateLimitedLog.withRateLimit((Logger)log).maxRate(10).every(Duration.of(1L, ChronoUnit.MINUTES)).build();
    static final int MEMBER_CONFIG_CACHE_MAX_SIZE = 1000;
    private static final int INITIAL_CACHE_EXPIRATION_SECONDS = 10;
    private static final int IGNORED_XML_PARSING_TIME_COUNT = 2;
    private static final int TOO_LOW_MEASUREMENT_COUNT = 2;
    private static final double MILLIS_PER_SECOND = 1000.0;
    private static final double XML_PARSING_TTL_DOUBLING_THRESHOLD = 0.3;
    private static final double CONFIG_READING_TTL_DOUBLING_THRESHOLD = 0.3;
    private static final int MAX_RINGBUFFER_SIZE = 10;
    private static final int MIN_RINGBUFFER_SIZE = 3;
    private final AtomicInteger alreadyIgnoredXmlParsingCount = new AtomicInteger();
    private final CacheCreator cacheCreator;
    private final Clock clock;
    private final OperationDispatcher dispatcher;
    private final MemberConfigFactory memberConfigFactory;
    private final ConcurrentMap<String, LoadingCache<String, InstrumentedMemberConfig>> caches = new ConcurrentHashMap();
    private final ConcurrentMap<String, ConcurrentArrayRingbuffer<Long>> lastReadTimesPerCluster = new ConcurrentHashMap();
    private final ConcurrentMap<String, ConcurrentArrayRingbuffer<Long>> lastParseTimesPerCluster = new ConcurrentHashMap();
    private final ConcurrentMap<String, Integer> cacheTtlPerCluster = new ConcurrentHashMap();
    private final ClusterSizeProvider clusterSizeProvider;
    private final ApplicationEventPublisher publisher;
    private final MCConfigurationProperties mcProperties;

    DefaultMemberConfigService(OperationDispatcher dispatcher, CacheCreator cacheCreator, Clock clock, MemberConfigFactory memberConfigFactory, ClusterSizeProvider clusterSizeProvider, ApplicationEventPublisher publisher, MCConfigurationProperties mcProperties) {
        this.dispatcher = dispatcher;
        this.cacheCreator = this.metadataMaintainingCacheCreator(cacheCreator);
        this.clock = clock;
        this.clusterSizeProvider = clusterSizeProvider;
        this.memberConfigFactory = memberConfigFactory;
        this.publisher = publisher;
        this.mcProperties = mcProperties;
    }

    @Autowired
    public DefaultMemberConfigService(OperationDispatcher dispatcher, MemberConfigFactory memberConfigFactory, ClusterSizeProvider clusterSizeProvider, ApplicationEventPublisher publisher, MCConfigurationProperties mcProperties) {
        this.dispatcher = dispatcher;
        this.cacheCreator = this.defaultLoadingCacheCreator();
        this.clock = Clock.systemDefaultZone();
        this.clusterSizeProvider = clusterSizeProvider;
        this.memberConfigFactory = memberConfigFactory;
        this.publisher = publisher;
        this.mcProperties = mcProperties;
    }

    private ConcurrentArrayRingbuffer<Long> createRingbuffer(MemberIdentifier member) {
        int ringbufferSize = (Integer)this.clusterSizeProvider.apply((Object)member.getClusterName());
        ringbufferSize = Math.min(10, Math.max(3, ringbufferSize));
        return new ConcurrentArrayRingbuffer(ringbufferSize);
    }

    public void configXmlParsed(MemberIdentifier member, long parsingTimeMillis) {
        if (this.alreadyIgnoredXmlParsingCount.incrementAndGet() <= 2) {
            return;
        }
        ConcurrentArrayRingbuffer lastParseTimesInCluster = this.lastParseTimesPerCluster.computeIfAbsent(member.getClusterName(), __ -> this.createRingbuffer(member));
        lastParseTimesInCluster.add((Object)parsingTimeMillis);
        if (lastParseTimesInCluster.size() <= 2L) {
            return;
        }
        ConcurrentArrayRingbuffer.RingbufferSlice slice = lastParseTimesInCluster.copyFrom(0L);
        double sumParseTime = (double)slice.stream().mapToLong(Long::valueOf).sum() / 1000.0;
        Integer currentTtl = (Integer)this.cacheTtlPerCluster.get(member.getClusterName());
        if (currentTtl != null && sumParseTime > (double)currentTtl.intValue() * 0.3) {
            this.doubleTtlForCluster(member.getClusterName(), currentTtl.intValue());
        }
    }

    void configObtained(MemberIdentifier memberIdent, long timeInMillis) {
        ConcurrentArrayRingbuffer lastReadTimesInCluster = this.lastReadTimesPerCluster.computeIfAbsent(memberIdent.getClusterName(), __ -> this.createRingbuffer(memberIdent));
        lastReadTimesInCluster.add((Object)timeInMillis);
        if (lastReadTimesInCluster.size() <= 2L) {
            return;
        }
        ConcurrentArrayRingbuffer.RingbufferSlice slice = lastReadTimesInCluster.copyFrom(0L);
        double avgReadTime = slice.stream().mapToLong(Long::valueOf).average().getAsDouble() / 1000.0;
        Integer currentTtl = (Integer)this.cacheTtlPerCluster.get(memberIdent.getClusterName());
        if (currentTtl != null && avgReadTime > (double)currentTtl.intValue() * 0.3) {
            this.doubleTtlForCluster(memberIdent.getClusterName(), currentTtl.intValue());
        }
    }

    private void doubleTtlForCluster(String clusterName, int currentTtl) {
        int newTtl = currentTtl * 2;
        log.warn("increasing configuration cache TTL from {} to {}", (Object)currentTtl, (Object)newTtl);
        LoadingCache newCache = (LoadingCache)this.cacheCreator.apply((Object)newTtl, (Object)clusterName);
        newCache.putAll((Map)((LoadingCache)this.caches.get(clusterName)).asMap());
        this.caches.put(clusterName, newCache);
        this.cacheTtlPerCluster.put(clusterName, newTtl);
    }

    private String doGetMemberConfig(MemberIdentifier memberIdent) {
        long startAt = this.clock.millis();
        String rawXmlConfig = (String)this.dispatcher.executeOnMember(memberIdent, MCClient::getMemberConfig, e -> "failed to get remote config: " + e.getMessage());
        long duration = Math.max(0L, this.clock.millis() - startAt);
        this.configObtained(memberIdent, duration);
        return rawXmlConfig;
    }

    private CacheCreator metadataMaintainingCacheCreator(CacheCreator wrapped) {
        return (ttl, cluster) -> {
            this.cacheTtlPerCluster.put(cluster, ttl);
            return (LoadingCache)wrapped.apply(ttl, cluster);
        };
    }

    private CacheCreator defaultLoadingCacheCreator() {
        return this.metadataMaintainingCacheCreator((ttl, cluster) -> CacheBuilder.newBuilder().maximumSize(1000L).refreshAfterWrite((long)ttl.intValue(), TimeUnit.SECONDS).build(CacheLoader.from(key -> {
            MemberIdentifier memberIdent = MemberIdentifier.of((String)cluster, (String)key);
            return this.createMemberConfig(this.doGetMemberConfig(memberIdent), memberIdent);
        })));
    }

    private InstrumentedMemberConfig createMemberConfig(String rawXmlConfig, MemberIdentifier memberIdent) {
        return this.memberConfigFactory.createMemberConfig(rawXmlConfig).instrument((XmlParsingTimeListener)this, this.clock, memberIdent);
    }

    @EventListener
    public void memberStateAdded(MembersJoinedEvent event) {
        event.getMembers().stream().map(member -> MemberIdentifier.of((String)event.getCluster(), (Member)member)).forEach(arg_0 -> this.getMemberConfig(arg_0));
        this.publisher.publishEvent((ApplicationEvent)new MembersConfigsParsedEvent(event));
    }

    private LoadingCache<String, InstrumentedMemberConfig> getCache(String clusterName) {
        return this.caches.computeIfAbsent(clusterName, __ -> (LoadingCache)this.cacheCreator.apply((Object)10, (Object)clusterName));
    }

    public MemberConfig getMemberConfig(MemberIdentifier memberIdent) {
        try {
            return (MemberConfig)this.getCache(memberIdent.getClusterName()).get((Object)memberIdent.getMemberAddress());
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            TASK_EXCEPTION_LOGGER.error(e.getMessage(), e);
            return null;
        }
    }

    public Optional<MemberConfig> getRandomConfigFromCluster(String cluster) {
        ConcurrentMap currentlyAvailableConfigs = this.getCache(cluster).asMap();
        if (currentlyAvailableConfigs.isEmpty()) {
            return Optional.empty();
        }
        InstrumentedMemberConfig randomMemberConfig = (InstrumentedMemberConfig)currentlyAvailableConfigs.get(currentlyAvailableConfigs.keySet().iterator().next());
        return Optional.ofNullable(randomMemberConfig);
    }

    public Map<MemberIdentifier, MemberConfig> asMap() {
        HashMap<MemberIdentifier, MemberConfig> rval = new HashMap<MemberIdentifier, MemberConfig>();
        this.caches.forEach((cluster, cache) -> cache.asMap().forEach((memberAddress, config) -> rval.put(MemberIdentifier.of((String)cluster, (String)memberAddress), (MemberConfig)config)));
        return rval;
    }

    @EventListener
    public void removeMemberConfig(MemberRemovedEvent event) {
        String key = MemberUtil.getMemberAddress((Member)event.getMember());
        LoadingCache cacheForCluster = this.getCache(event.getCluster());
        ((InstrumentedMemberConfig)cacheForCluster.asMap().get(key)).detachListener();
        cacheForCluster.invalidate((Object)key);
    }

    public void reloadConfigs(String cluster) {
        Set membersOfCluster = this.asMap().keySet().stream().filter(memberIdent -> cluster.equals(memberIdent.getClusterName())).collect(Collectors.toSet());
        try {
            List<CompletableFuture> futures = membersOfCluster.stream().map(memberIdent -> this.dispatcher.asyncExecuteOnMember(memberIdent, MCClient::getMemberConfig).thenApply(newConfigXml -> {
                this.getCache(memberIdent.getClusterName()).put((Object)memberIdent.getMemberAddress(), (Object)this.createMemberConfig(newConfigXml, memberIdent));
                return newConfigXml;
            })).collect(Collectors.toList());
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(this.mcProperties.getClusterOperationTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

