/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.jet.EdgeDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.jet.EdgeTransceptionDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.jet.ProcessorDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.jet.VertexDTO;
import com.hazelcast.webmonitor.controller.dto.jet.EdgeInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.EdgeTransceptionInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JobInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.ProcessorInfoDTO;
import com.hazelcast.webmonitor.controller.dto.jet.VertexInfoDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredJetStatsAggregator;
import com.hazelcast.webmonitor.service.ClusteredJetStatsProvider;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.JobMXBean;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.ObjectName;

public class JobMXBeanImpl
implements BaseManagementBean,
JobMXBean {
    public static final String TYPE_NAME = "Jobs";
    private final ClusteredJetStatsProvider clusteredJetStatsProvider;
    private final String cluster;
    private final String id;
    private volatile JobInfoDTO jobInfo;
    private volatile List<VertexDTO> vertices;
    private volatile List<EdgeDTO> edges;

    public JobMXBeanImpl(ClusteredJetStatsProvider clusteredJetStatsProvider, String cluster, String id) {
        this.clusteredJetStatsProvider = clusteredJetStatsProvider;
        this.cluster = cluster;
        this.id = id;
        this.updateJobRelatedInfo();
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.cluster, (String)TYPE_NAME, (String)this.id);
    }

    public void updateFrom(AllState state) {
        this.updateJobRelatedInfo();
    }

    private void updateJobRelatedInfo() {
        ClusteredJetStatsAggregator.ClusteredJobInfoDTO clusteredJobInfoDTO = (ClusteredJetStatsAggregator.ClusteredJobInfoDTO)this.clusteredJetStatsProvider.getJobs(this.cluster).get(this.id);
        this.jobInfo = clusteredJobInfoDTO.getJobInfo();
        this.vertices = clusteredJobInfoDTO.getVertices().stream().map(arg_0 -> this.toVertexDTO(arg_0)).collect(Collectors.toList());
        this.edges = clusteredJobInfoDTO.getEdges().stream().map(arg_0 -> this.toEdgeDTO(arg_0)).collect(Collectors.toList());
    }

    private EdgeDTO toEdgeDTO(EdgeInfoDTO in) {
        return EdgeDTO.builder().sourceVertex(in.getSourceVertex()).fromOrdinal(in.getFromOrdinal()).targetVertex(in.getTargetVertex()).toOrdinal(in.getToOrdinal()).totalRecordsFlow(in.getTotalRecordsFlow()).lastMinRecordsFlow(in.getLastMinRecordsFlow()).build();
    }

    private VertexDTO toVertexDTO(VertexInfoDTO in) {
        return VertexDTO.builder().id(in.getId()).totalIn(in.getTotalIn()).lastMinIn(in.getLastMinIn()).totalOut(in.getTotalOut()).lastMinOut(in.getLastMinOut()).maxLatencyToRealTime(in.getMaxLatencyToRealTime()).skew(in.getSkew()).parallelism(in.getParallelism()).globalParallelism(in.getGlobalParallelism()).incoming(this.toEdgeTransceptionDTOMap(in.getIncoming())).outgoing(this.toEdgeTransceptionDTOMap(in.getOutgoing())).processors(this.toProcessorDTOMap(in.getProcessors())).build();
    }

    private Map<Integer, ProcessorDTO> toProcessorDTOMap(Map<Integer, ProcessorInfoDTO> in) {
        HashMap<Integer, ProcessorDTO> out = new HashMap<Integer, ProcessorDTO>();
        for (Map.Entry<Integer, ProcessorInfoDTO> entry : in.entrySet()) {
            out.put(entry.getKey(), this.toProcessorDTO(entry.getValue()));
        }
        return out;
    }

    private ProcessorDTO toProcessorDTO(ProcessorInfoDTO in) {
        return ProcessorDTO.builder().processorId(in.getProcessorId()).queueSize(in.getQueueSize()).queueCapacity(in.getQueueCapacity()).emittedCount(in.getEmittedCount()).receivedCount(in.getReceivedCount()).lastForwardedWmLatency(in.getLastForwardedWmLatency()).capPercentage(in.getCapPercentage()).build();
    }

    private Map<String, EdgeTransceptionDTO> toEdgeTransceptionDTOMap(Map<String, EdgeTransceptionInfoDTO> in) {
        HashMap<String, EdgeTransceptionDTO> out = new HashMap<String, EdgeTransceptionDTO>();
        for (Map.Entry<String, EdgeTransceptionInfoDTO> entry : in.entrySet()) {
            EdgeTransceptionInfoDTO info = entry.getValue();
            EdgeTransceptionDTO dto = EdgeTransceptionDTO.builder().ordinal(info.getOrdinal()).total(info.getTotal()).lastMin(info.getLastMin()).build();
            out.put(entry.getKey(), dto);
        }
        return out;
    }

    public String getName() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public String getLastExecutionId() {
        if (this.jobInfo == null) {
            return null;
        }
        return this.jobInfo.getLastExecutionId();
    }

    public String getJobName() {
        return this.jobInfo.getName();
    }

    public String getStatus() {
        return this.jobInfo.getStatus().name();
    }

    public String getConfigJson() {
        return SerializationUtil.OBJECT_MAPPER.writeValueAsString((Object)this.jobInfo.getConfig());
    }

    public long getSubmissionTime() {
        return this.jobInfo.getSubmissionTime();
    }

    public long getTotalIn() {
        return this.jobInfo.getStats().getTotalIn();
    }

    public long getTotalOut() {
        return this.jobInfo.getStats().getTotalOut();
    }

    public long getLastMinIn() {
        return this.jobInfo.getStats().getLastMinIn();
    }

    public long getLastMinOut() {
        return this.jobInfo.getStats().getLastMinOut();
    }

    public int getRunningNodeCount() {
        return this.jobInfo.getStats().getRunningNodeCount();
    }

    public int getTotalNodeCount() {
        return this.jobInfo.getStats().getTotalNodeCount();
    }

    public long getCompletionTime() {
        return this.jobInfo.getCompletionTime();
    }

    public String getFailure() {
        return this.jobInfo.getFailure();
    }

    public String getProcessingGuarantee() {
        return this.jobInfo.getProcessingGuarantee().name();
    }

    public long getSnapshotIntervalMillis() {
        return this.jobInfo.getSnapshotDetails().getSnapshotIntervalMillis();
    }

    public long getLastSnapshotKeys() {
        return this.jobInfo.getSnapshotDetails().getLastSnapshotKeys();
    }

    public long getLastSnapshotSize() {
        return this.jobInfo.getSnapshotDetails().getLastSnapshotSize();
    }

    public long getLastSnapshotTime() {
        return this.jobInfo.getSnapshotDetails().getLastSnapshotTime();
    }

    public long getLastSnapshotDuration() {
        return this.jobInfo.getSnapshotDetails().getLastSnapshotDuration();
    }

    public List<VertexDTO> getVertices() {
        return this.vertices;
    }

    public List<EdgeDTO> getEdges() {
        return this.edges;
    }
}

