/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.config.properties.SSLProperties;
import com.hazelcast.webmonitor.ssl.SSLContextFactory;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class JmxSslRMIClientSocketFactory
extends SslRMIClientSocketFactory {
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLContext sslContext = this.createSSLContext();
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(host, port);
        this.setEnabledCipherSuites(sslSocket);
        this.setEnabledProtocols(sslSocket);
        return sslSocket;
    }

    private SSLContext createSSLContext() {
        try {
            return SSLContextFactory.createSSLContext((SSLProperties)new SSLProperties());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SSL context for JMX RMI client sockets.", e);
        }
    }

    private void setEnabledCipherSuites(SSLSocket sslSocket) throws IOException {
        String enabledCipherSuites = System.getProperty("javax.rmi.ssl.client.enabledCipherSuites");
        if (enabledCipherSuites != null) {
            String[] enabledCipherSuitesList = enabledCipherSuites.split(",");
            try {
                sslSocket.setEnabledCipherSuites(enabledCipherSuitesList);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    private void setEnabledProtocols(SSLSocket sslSocket) throws IOException {
        String enabledProtocols = System.getProperty("javax.rmi.ssl.client.enabledProtocols");
        if (enabledProtocols != null) {
            String[] enabledProtocolsList = enabledProtocols.split(",");
            try {
                sslSocket.setEnabledProtocols(enabledProtocolsList);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

