/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.ConnectionManagerStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.ConnectionManagerMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class ConnectionManagerMXBeanImpl
implements ConnectionManagerMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Services";
    public static final String SERVICE_NAME = "ConnectionManager";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String member;
    private volatile ConnectionManagerStatsDTO stats;

    public ConnectionManagerMXBeanImpl(ClusteredStatsService statsService, String cluster, String member) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.member = member;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getConnectionManagerStats(this.cluster, this.member);
    }

    public String getName() {
        return this.member;
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.cluster, (String)TYPE_NAME, (String)SERVICE_NAME, (String)this.member);
    }

    public int getClientConnectionCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ConnectionManagerStatsDTO::getClientConnectionCount);
    }

    public int getActiveConnectionCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ConnectionManagerStatsDTO::getActiveConnectionCount);
    }

    public int getConnectionCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ConnectionManagerStatsDTO::getConnectionCount);
    }
}

