/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.MemberMetricsSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;

public class OsMetricsAvailabilityAnalyzer
implements Analyzer {
    private static final String JVM_ARGS_ADVICE = "If the member runs on Java 9+ the startup flag `--add-opens jdk.management/com.sun.management.internal=ALL-UNNAMED` is required to read OS metrics";
    private final MemberMetricsSupplier memberMetricsSupplier;

    public AnalysisOutcome analyze(SourceDataFilter filter) {
        ArrayList problems = new ArrayList();
        filter.filter((Map)this.memberMetricsSupplier.get()).forEach((memberIdentifier, metricValue) -> {
            if (metricValue == null || metricValue.isEmpty()) {
                problems.add(new MemberProblem("Can't read the member operating system metrics", JVM_ARGS_ADVICE, memberIdentifier));
            }
        });
        return AnalysisOutcome.success((String)this.describeSelf(), problems);
    }

    public String describeSelf() {
        return "Checking if member OS metrics are available";
    }

    @ConstructorProperties(value={"memberMetricsSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OsMetricsAvailabilityAnalyzer(MemberMetricsSupplier memberMetricsSupplier) {
        this.memberMetricsSupplier = memberMetricsSupplier;
    }
}

