/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class MemberComparisonProblem
extends Problem {
    private final Set<MemberIdentifier> normalGroup;
    private final Set<OutlierGroup> outlierGroups;

    public static MemberComparisonProblem attributeDifference(String attribute, String ownerDescription, OutlierGroup ... outlierGroups) {
        return MemberComparisonProblem.builder().description("The " + attribute + " attribute is inconsistent across member configurations" + (ownerDescription == null ? "" : " for " + ownerDescription)).advice("Set the same " + attribute + " attribute in all member configurations").outlierGroups(new HashSet<OutlierGroup>(Arrays.asList(outlierGroups))).build();
    }

    public static MemberComparisonProblem missingListElement(String elementTypeDescription, String elemId, String ownerDescription, Set<MemberIdentifier> membersContainingTheElem, Set<MemberIdentifier> membersMissingTheElem) {
        String capitalized = elementTypeDescription.substring(0, 1).toUpperCase() + elementTypeDescription.substring(1);
        MemberComparisonProblemBuilder builder = MemberComparisonProblem.builder();
        if (ownerDescription == null) {
            builder.description(String.format("%s %s is not configured on all members", capitalized, elemId));
        } else {
            builder.description(String.format("%s %s is not configured on all members for %s", capitalized, elemId, ownerDescription));
        }
        return builder.advice(String.format("Configure %s %s on all members", elementTypeDescription, elemId)).addOutlierGroup(OutlierGroup.of((String)(elemId + " is configured"), membersContainingTheElem)).addOutlierGroup(OutlierGroup.of((String)(elemId + " is missing"), membersMissingTheElem)).build();
    }

    public MemberComparisonProblem(String description, String advice, Set<MemberIdentifier> normalGroup, Set<OutlierGroup> outlierGroups) {
        super(description, advice);
        this.normalGroup = Collections.unmodifiableSet(new HashSet<MemberIdentifier>(normalGroup));
        this.outlierGroups = Collections.unmodifiableSet(new HashSet<OutlierGroup>(outlierGroups));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static MemberComparisonProblemBuilder builder() {
        return new MemberComparisonProblemBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemberComparisonProblem)) {
            return false;
        }
        MemberComparisonProblem other = (MemberComparisonProblem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set this$normalGroup = this.getNormalGroup();
        Set other$normalGroup = other.getNormalGroup();
        if (this$normalGroup == null ? other$normalGroup != null : !((Object)this$normalGroup).equals(other$normalGroup)) {
            return false;
        }
        Set this$outlierGroups = this.getOutlierGroups();
        Set other$outlierGroups = other.getOutlierGroups();
        return !(this$outlierGroups == null ? other$outlierGroups != null : !((Object)this$outlierGroups).equals(other$outlierGroups));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemberComparisonProblem;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set $normalGroup = this.getNormalGroup();
        result = result * 59 + ($normalGroup == null ? 43 : ((Object)$normalGroup).hashCode());
        Set $outlierGroups = this.getOutlierGroups();
        result = result * 59 + ($outlierGroups == null ? 43 : ((Object)$outlierGroups).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<MemberIdentifier> getNormalGroup() {
        return this.normalGroup;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<OutlierGroup> getOutlierGroups() {
        return this.outlierGroups;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MemberComparisonProblem(normalGroup=" + this.getNormalGroup() + ", outlierGroups=" + this.getOutlierGroups() + ")";
    }
}

