/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
class MapCustomAttributeAnalyzer
extends SemanticConfigAnalyzer {
    static String joinSorted(Collection<String> elems) {
        ArrayList<String> copy = new ArrayList<String>(elems);
        copy.sort(String::compareTo);
        return String.join((CharSequence)", ", copy);
    }

    MapCustomAttributeAnalyzer(MemberConfigSupplier memberConfigs) {
        super(memberConfigs);
    }

    protected List<Problem> analyze(MemberConfig config) {
        ArrayList<Problem> rval = new ArrayList<Problem>();
        config.toEffectiveConfig().getMapConfigs().forEach((mapName, mapCfg) -> {
            List attributeConfigs = mapCfg.getAttributeConfigs();
            if (attributeConfigs != null && !attributeConfigs.isEmpty()) {
                HashMap extractorsByAttribute = new HashMap(attributeConfigs.size());
                HashMap attributesByExtractor = new HashMap(attributeConfigs.size());
                attributeConfigs.forEach(attrCfg -> {
                    extractorsByAttribute.computeIfAbsent(attrCfg.getName(), attrName -> new HashSet(1)).add(attrCfg.getExtractorClassName());
                    attributesByExtractor.computeIfAbsent(attrCfg.getExtractorClassName(), name -> new HashSet(1)).add(attrCfg.getName());
                });
                extractorsByAttribute.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).forEach(entry -> rval.add((Problem)new ClusterWideProblem(String.format("Custom attribute %s of map %s is configured with more than one extractors: %s", entry.getKey(), mapName, MapCustomAttributeAnalyzer.joinSorted((Collection)((Collection)entry.getValue()))), String.format("Configure %s with exactly one extractor class", entry.getKey()))));
                attributesByExtractor.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).forEach(entry -> rval.add((Problem)new ClusterWideProblem(String.format("Attribute extractor %s is configured in %s to extract multiple attributes: %s", entry.getKey(), mapName, MapCustomAttributeAnalyzer.joinSorted((Collection)((Collection)entry.getValue()))), String.format("Configure %s to extract only one attribute", entry.getKey()))));
            }
        });
        return rval;
    }

    public String describeSelf() {
        return "Checking if custom attributes are unique per extractor";
    }
}

