/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.healthcheck.AbstractIndexListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
class IndexRedundancyAnalyzer
extends SemanticConfigAnalyzer {
    IndexRedundancyAnalyzer(MemberConfigSupplier memberConfigs) {
        super(memberConfigs);
    }

    protected List<Problem> analyze(MemberConfig memberConfig) {
        return memberConfig.toEffectiveConfig().getMapConfigs().values().stream().flatMap(arg_0 -> this.analyze(arg_0)).collect(Collectors.toList());
    }

    private Stream<Problem> analyze(MapConfig mapConfig) {
        String mapName = mapConfig.getName();
        List problems = this.analyzeIndexes("map " + mapName, mapConfig.getIndexConfigs());
        Stream queryCacheIndexProblems = mapConfig.getQueryCacheConfigs().stream().map(queryCache -> this.analyzeIndexes(String.format("query cache %s of map %s", queryCache.getName(), mapName), queryCache.getIndexConfigs())).flatMap(Collection::stream);
        return Stream.concat(problems.stream(), queryCacheIndexProblems);
    }

    protected List<Problem> analyzeIndexes(String owningObjectDescription, List<IndexConfig> indexConfigs) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        boolean[] alreadyRecognizedAsRedundant = new boolean[indexConfigs.size()];
        for (int i = 0; i < indexConfigs.size(); ++i) {
            IndexConfig index = indexConfigs.get(i);
            if (alreadyRecognizedAsRedundant[i]) continue;
            ArrayList<IndexConfig> redundantConfigs = new ArrayList<IndexConfig>(Collections.singletonList(index));
            for (int j = i + 1; j < indexConfigs.size(); ++j) {
                IndexConfig matchCandidate = indexConfigs.get(j);
                if (!this.isRedundant(index, matchCandidate)) continue;
                redundantConfigs.add(matchCandidate);
                alreadyRecognizedAsRedundant[j] = true;
            }
            if (redundantConfigs.size() <= 1) continue;
            problems.add(this.createProblem(owningObjectDescription, redundantConfigs));
        }
        return problems;
    }

    protected boolean isRedundant(IndexConfig one, IndexConfig other) {
        if (!Objects.equals(one.getType(), other.getType())) {
            return false;
        }
        List oneAttributes = one.getAttributes();
        List otherAttributes = other.getAttributes();
        int end = Math.min(oneAttributes.size(), otherAttributes.size());
        for (int i = 0; i < end; ++i) {
            if (Objects.equals(oneAttributes.get(i), otherAttributes.get(i))) continue;
            return false;
        }
        return true;
    }

    protected Problem createProblem(String owningObjectDescription, Collection<IndexConfig> redundantConfigs) {
        IndexConfig indexWithLongestAttributeList = redundantConfigs.stream().max(Comparator.comparingInt(i -> i.getAttributes().size())).orElseThrow(IllegalStateException::new);
        ArrayList<IndexConfig> copy = new ArrayList<IndexConfig>(redundantConfigs);
        copy.remove(indexWithLongestAttributeList);
        copy.sort(Comparator.comparing(Object::toString));
        return new ClusterWideProblem(String.format("The following indexes of %s are redundant: %s", owningObjectDescription, IndexRedundancyAnalyzer.describe(redundantConfigs)), "Delete " + IndexRedundancyAnalyzer.describe(copy));
    }

    private static String describe(Collection<IndexConfig> indexes) {
        return indexes.stream().map(AbstractIndexListEquivalence.IndexConfigIdentifier::new).map(Object::toString).sorted().collect(Collectors.joining(", "));
    }

    public String describeSelf() {
        return "Checking if map and query cache indexes are not redundant";
    }
}

