/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.metrics.DataPointsReceivedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class HealthCheckMetricsCollector {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthCheckMetricsCollector.class);
    private static final int TTL_IN_SECONDS = 600;
    private final ConcurrentHashMap<String, Cache<MemberIdentifier, List<MetricDataPoint>>> storage = new ConcurrentHashMap();

    @EventListener
    public void dataPointsReceived(DataPointsReceivedEvent event) {
        event.getDataPoints().stream().filter(dataPoint -> this.storage.containsKey(dataPoint.getName())).collect(Collectors.groupingBy(MetricDataPoint::getName)).forEach((metricName, dataPoints) -> this.storage.computeIfAbsent(metricName, key -> this.createCache()).put((Object)event.getMemberIdent(), dataPoints));
    }

    public void startCollectingMetric(String metricName) {
        this.storage.computeIfAbsent(metricName, key -> this.createCache());
    }

    public Map<MemberIdentifier, List<MetricDataPoint>> getMemberMetric(String metricName) {
        return Optional.ofNullable((Cache)this.storage.get(metricName)).map(cache -> cache.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(Collections.emptyMap());
    }

    private Cache<MemberIdentifier, List<MetricDataPoint>> createCache() {
        return Caffeine.newBuilder().expireAfterWrite(600L, TimeUnit.SECONDS).build();
    }
}

