/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.controller.dto.healthcheck.AddIgnoreListEntryRequestDTO;
import com.hazelcast.webmonitor.model.sql.HealthCheckIgnoreListEntry;
import com.hazelcast.webmonitor.repositories.sql.HealthCheckIgnoreListDAO;
import com.hazelcast.webmonitor.service.Licensed;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcomeSource;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreListEntryAlreadyExistsException;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class DefaultHealthCheckService
implements HealthCheckService {
    private final List<AnalysisOutcomeSource> analyzers;
    private final Supplier<String> loggedInUserName;
    private final HealthCheckIgnoreListDAO ignoreListDAO;

    DefaultHealthCheckService(List<AnalysisOutcomeSource> analyzers, HealthCheckIgnoreListDAO ignoreListDAO, Supplier<String> loggedInUserName) {
        this.analyzers = Collections.unmodifiableList(new ArrayList<AnalysisOutcomeSource>(analyzers));
        this.ignoreListDAO = ignoreListDAO;
        this.loggedInUserName = Objects.requireNonNull(loggedInUserName);
    }

    @Licensed
    public List<AnalysisOutcome> analyze(String cluster) {
        SourceDataFilter filter = new SourceDataFilter(cluster);
        IgnoreList ignoreList = new IgnoreList(this.ignoreListDAO.queryIgnoreList(cluster));
        List<AnalysisOutcome> outcomes = this.analyzers.stream().map(analyzer -> analyzer.getOutcomes(filter)).flatMap(Collection::stream).filter(Objects::nonNull).map(outcome -> this.excludeIgnoredProblems(outcome, ignoreList)).collect(Collectors.toList());
        return outcomes;
    }

    private AnalysisOutcome excludeIgnoredProblems(AnalysisOutcome outcome, IgnoreList ignoreList) {
        if (outcome.isEmpty()) {
            return outcome;
        }
        ArrayList<Problem> problems = new ArrayList<Problem>(outcome.getIdentifiedProblems());
        boolean isAnyRemoved = problems.removeIf(arg_0 -> ((IgnoreList)ignoreList).ignores(arg_0));
        if (isAnyRemoved) {
            return outcome.withProblems(problems);
        }
        return outcome;
    }

    public void addIgnoreListEntry(String cluster, AddIgnoreListEntryRequestDTO request) throws IgnoreListEntryAlreadyExistsException {
        this.ignoreListDAO.insertEntry(new HealthCheckIgnoreListEntry(request.getDescription(), request.getAdvice(), cluster, (String)this.loggedInUserName.get()));
    }
}

