/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.ClientPermissionIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.ClientPermissionListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.ListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class ClientPermissionListEquivalence
extends ListEquivalence<SecurityConfig, PermissionConfig, ClientPermissionIdentifier> {
    ClientPermissionListEquivalence(Map<MemberIdentifier, Config> memberConfigs) {
        super(memberConfigs, false);
    }

    AttributeEquivalence<PermissionConfig> createElementAttributeEquivalence(ClientPermissionIdentifier elemId, Map<PermissionConfig, Set<MemberIdentifier>> groupsByValues) {
        return new ClientPermissionAttributeEquivalence(groupsByValues, this.memberConfigs, elemId);
    }

    MemberComparisonProblem createProblemForMissingElement(ClientPermissionIdentifier elemId, Set<MemberIdentifier> membersMissingTheElem, Set<MemberIdentifier> membersContainingTheElem) {
        return MemberComparisonProblem.builder().description(String.format("Client permission for %s is not configured on all members", elemId.toString())).advice(String.format("Configure permission for %s on all members", elemId)).addOutlierGroup(OutlierGroup.of((String)("Permission config for " + elemId + " is missing"), membersMissingTheElem)).addOutlierGroup(OutlierGroup.of((String)("Permission config for " + elemId + " is configured"), membersContainingTheElem)).build();
    }

    SecurityConfig extractOwner(Config config) {
        return config.getSecurityConfig();
    }

    Map<ClientPermissionIdentifier, PermissionConfig> extractElements(SecurityConfig owner) {
        return owner.getClientPermissionConfigs().stream().collect(Collectors.toMap(config -> new ClientPermissionIdentifier(config.getType(), config.getName(), config.getPrincipal()), Function.identity()));
    }
}

