/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.ClientConnectionInfo;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCountAnalyzer
implements Analyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientCountAnalyzer.class);
    public static final String CLIENT_COUNT_ANALYZER_DESCRIPTION = "Checking if the number of clients per member is exceeded";
    public static final String CLIENT_COUNT_ANALYZER_ADVICE = "See Hazelcast Support for further details at https://support.hazelcast.com/s/article/Hazelcast-Support-Policy";
    public static final int MAXIMUM_UNI_SOCKET_CLIENTS_PER_MEMBER = 1000;
    public static final int MAXIMUM_MULTI_SOCKET_CLIENTS_PER_MEMBER = 100;
    private final StateManager stateManager;

    public AnalysisOutcome analyze(SourceDataFilter filter) {
        String cluster = filter.getCluster();
        AllState latestState = this.stateManager.getLatestState(cluster);
        ArrayList warnings = new ArrayList();
        if (latestState != null) {
            Map clientConnectionInfoPerMember = latestState.getClientConnectionInfoPerMember();
            for (Map.Entry entry : clientConnectionInfoPerMember.entrySet()) {
                String memberAddress = (String)entry.getKey();
                MemberIdentifier memberIdentifier = MemberIdentifier.of((String)cluster, (String)memberAddress);
                Map<Boolean, Long> clientsPartitionedBySmartFlag = ((List)entry.getValue()).stream().collect(Collectors.partitioningBy(ClientConnectionInfo::isSmartClient, Collectors.counting()));
                this.getMemberProblem(memberIdentifier, clientsPartitionedBySmartFlag.get(Boolean.FALSE).longValue(), false).ifPresent(warnings::add);
                this.getMemberProblem(memberIdentifier, clientsPartitionedBySmartFlag.get(Boolean.TRUE).longValue(), true).ifPresent(warnings::add);
            }
        }
        return AnalysisOutcome.warning((String)this.describeSelf(), warnings);
    }

    private Optional<Problem> getMemberProblem(MemberIdentifier memberIdentifier, long clientsPerMember, boolean isMultiSocketClient) {
        long maxClientsPerMember;
        long l = maxClientsPerMember = isMultiSocketClient ? 100L : 1000L;
        if (clientsPerMember > maxClientsPerMember) {
            String description = String.format("%,d %s clients connected to member which exceeds Hazelcast Best Practices", clientsPerMember, isMultiSocketClient ? "multi-socket" : "uni-socket");
            log.debug(description);
            return Optional.of(new MemberProblem(description, CLIENT_COUNT_ANALYZER_ADVICE, memberIdentifier));
        }
        return Optional.empty();
    }

    public String describeSelf() {
        return CLIENT_COUNT_ANALYZER_DESCRIPTION;
    }

    @ConstructorProperties(value={"stateManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientCountAnalyzer(StateManager stateManager) {
        this.stateManager = stateManager;
    }
}

