/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;

public final class AnalysisOutcome {
    private final String analysisDescription;
    private final List<Problem> identifiedProblems;
    private final List<Problem> warnings;

    public static AnalysisOutcome noProblem(String analysisDescription) {
        return new AnalysisOutcome(analysisDescription, Collections.emptyList(), Collections.emptyList());
    }

    public static AnalysisOutcome success(String analysisDescription, List<Problem> identifiedProblems) {
        return new AnalysisOutcome(analysisDescription, identifiedProblems, Collections.emptyList());
    }

    public static AnalysisOutcome warning(String analysisDescription, List<Problem> warnings) {
        return new AnalysisOutcome(analysisDescription, Collections.emptyList(), warnings);
    }

    private AnalysisOutcome(String analysisDescription, List<Problem> identifiedProblems, List<Problem> warnings) {
        identifiedProblems.sort(Comparator.comparing(Problem::getDescription));
        warnings.sort(Comparator.comparing(Problem::getDescription));
        this.analysisDescription = analysisDescription;
        this.identifiedProblems = identifiedProblems;
        this.warnings = warnings;
    }

    public AnalysisOutcome withProblems(List<Problem> replacementProblems) {
        return new AnalysisOutcome(this.analysisDescription, replacementProblems, this.warnings);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.identifiedProblems.isEmpty() && this.warnings.isEmpty();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAnalysisDescription() {
        return this.analysisDescription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Problem> getIdentifiedProblems() {
        return this.identifiedProblems;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Problem> getWarnings() {
        return this.warnings;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalysisOutcome)) {
            return false;
        }
        AnalysisOutcome other = (AnalysisOutcome)o;
        String this$analysisDescription = this.getAnalysisDescription();
        String other$analysisDescription = other.getAnalysisDescription();
        if (this$analysisDescription == null ? other$analysisDescription != null : !this$analysisDescription.equals(other$analysisDescription)) {
            return false;
        }
        List this$identifiedProblems = this.getIdentifiedProblems();
        List other$identifiedProblems = other.getIdentifiedProblems();
        if (this$identifiedProblems == null ? other$identifiedProblems != null : !((Object)this$identifiedProblems).equals(other$identifiedProblems)) {
            return false;
        }
        List this$warnings = this.getWarnings();
        List other$warnings = other.getWarnings();
        return !(this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $analysisDescription = this.getAnalysisDescription();
        result = result * 59 + ($analysisDescription == null ? 43 : $analysisDescription.hashCode());
        List $identifiedProblems = this.getIdentifiedProblems();
        result = result * 59 + ($identifiedProblems == null ? 43 : ((Object)$identifiedProblems).hashCode());
        List $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "AnalysisOutcome(analysisDescription=" + this.getAnalysisDescription() + ", identifiedProblems=" + this.getIdentifiedProblems() + ", warnings=" + this.getWarnings() + ")";
    }
}

