/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AbstractIndexListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.ListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import java.util.Map;
import java.util.Set;

abstract class AbstractIndexListEquivalence<O>
extends ListEquivalence<O, IndexConfig, IndexConfigIdentifier> {
    private final String owningObjectDescription;

    AbstractIndexListEquivalence(Map<MemberIdentifier, Config> memberConfigs, String owningObjectDescription) {
        super(memberConfigs, true);
        this.owningObjectDescription = owningObjectDescription;
    }

    final MemberComparisonProblem createProblemForMissingElement(IndexConfigIdentifier elemId, Set<MemberIdentifier> membersMissingTheElem, Set<MemberIdentifier> membersContainingTheElem) {
        String objectIdDescription = elemId.toString();
        return MemberComparisonProblem.builder().description(String.format("%s for %s is not configured on all members", objectIdDescription, this.owningObjectDescription)).advice(String.format("Configure %s for %s on all members", objectIdDescription, this.owningObjectDescription)).addOutlierGroup(OutlierGroup.of((String)(objectIdDescription + " is configured"), membersContainingTheElem)).addOutlierGroup(OutlierGroup.of((String)(objectIdDescription + " is missing"), membersMissingTheElem)).build();
    }
}

