/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.dynamicconfig;

import com.hazelcast.config.Config;
import com.hazelcast.internal.config.ConfigNamespace;
import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;

public final class ConfigPatch {
    private static final Map<ConfigSections, Function<Config, Map<String, ?>>> SECTIONS_TO_MAP_GETTERS;
    private final String text;

    public static ConfigPatch ofText(String text) {
        return new ConfigPatch(text);
    }

    public ConfigPatch(String text) {
        this.text = text;
    }

    public Config toEffectiveConfig() {
        return Config.loadFromString((String)this.text);
    }

    public ConfigUpdateResult previewOn(MemberConfig originalConfig) {
        Config effective = originalConfig.toEffectiveConfig();
        Config patch = this.toEffectiveConfig();
        HashSet<ConfigNamespace> addedConfigs = new HashSet<ConfigNamespace>();
        HashSet ignoredConfigs = new HashSet();
        SECTIONS_TO_MAP_GETTERS.forEach((section, mapGetter) -> ((Map)mapGetter.apply(patch)).forEach((addedSectionName, addedConfig) -> {
            Set targetSet = ((Map)mapGetter.apply(effective)).containsKey(addedSectionName) ? ignoredConfigs : addedConfigs;
            targetSet.add(new ConfigNamespace(section, addedSectionName));
        }));
        if (patch.getLicenseKey() != null) {
            addedConfigs.add(new ConfigNamespace(ConfigSections.LICENSE_KEY));
        }
        return new ConfigUpdateResult(addedConfigs, ignoredConfigs);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getText() {
        return this.text;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigPatch)) {
            return false;
        }
        ConfigPatch other = (ConfigPatch)o;
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ConfigPatch(text=" + this.getText() + ")";
    }

    static {
        EnumMap<ConfigSections, Function<Config, Map>> sectionsToMapGetters = new EnumMap<ConfigSections, Function<Config, Map>>(ConfigSections.class);
        sectionsToMapGetters.put(ConfigSections.MAP, Config::getMapConfigs);
        sectionsToMapGetters.put(ConfigSections.QUEUE, Config::getQueueConfigs);
        sectionsToMapGetters.put(ConfigSections.CACHE, Config::getCacheConfigs);
        sectionsToMapGetters.put(ConfigSections.LIST, Config::getListConfigs);
        sectionsToMapGetters.put(ConfigSections.SET, Config::getSetConfigs);
        sectionsToMapGetters.put(ConfigSections.MULTIMAP, Config::getMultiMapConfigs);
        sectionsToMapGetters.put(ConfigSections.REPLICATED_MAP, Config::getReplicatedMapConfigs);
        sectionsToMapGetters.put(ConfigSections.RINGBUFFER, Config::getRingbufferConfigs);
        sectionsToMapGetters.put(ConfigSections.TOPIC, Config::getTopicConfigs);
        sectionsToMapGetters.put(ConfigSections.RELIABLE_TOPIC, Config::getReliableTopicConfigs);
        sectionsToMapGetters.put(ConfigSections.EXECUTOR_SERVICE, Config::getExecutorConfigs);
        sectionsToMapGetters.put(ConfigSections.DURABLE_EXECUTOR_SERVICE, Config::getDurableExecutorConfigs);
        sectionsToMapGetters.put(ConfigSections.SCHEDULED_EXECUTOR_SERVICE, Config::getScheduledExecutorConfigs);
        sectionsToMapGetters.put(ConfigSections.CARDINALITY_ESTIMATOR, Config::getCardinalityEstimatorConfigs);
        sectionsToMapGetters.put(ConfigSections.PN_COUNTER, Config::getPNCounterConfigs);
        sectionsToMapGetters.put(ConfigSections.FLAKE_ID_GENERATOR, Config::getFlakeIdGeneratorConfigs);
        sectionsToMapGetters.put(ConfigSections.WAN_REPLICATION, Config::getWanReplicationConfigs);
        SECTIONS_TO_MAP_GETTERS = Collections.unmodifiableMap(sectionsToMapGetters);
    }
}

