/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.conndiagnosis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.hazelcast.webmonitor.service.conndiagnosis.ConnectionCheck;
import com.hazelcast.webmonitor.service.conndiagnosis.ConnectionDiagnosis;
import com.hazelcast.webmonitor.service.conndiagnosis.DiagnosisStatus;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public final class ConnectionDiagnosis {
    @NotNull
    private final DiagnosisStatus status;
    @NotNull
    private final String cluster;
    @NotNull
    private final List<ConnectionCheck> checks;

    public ConnectionDiagnosis(String cluster) {
        this(DiagnosisStatus.IN_PROGRESS, cluster, new ArrayList());
    }

    public ConnectionDiagnosis addCheck(ConnectionCheck check) {
        Objects.requireNonNull(check);
        if (this.sameAsLastCheck(check)) {
            return this;
        }
        DiagnosisStatus newStatus = check.getStatus() == DiagnosisStatus.FAILURE ? DiagnosisStatus.FAILURE : this.status;
        ArrayList<ConnectionCheck> newChecks = new ArrayList<ConnectionCheck>(this.checks.size() + 1);
        newChecks.addAll(this.checks);
        newChecks.add(check);
        return this.toBuilder().status(newStatus).checks(newChecks).build();
    }

    @JsonIgnore
    public boolean isInTerminalStatus() {
        return this.status == DiagnosisStatus.SUCCESS || this.status == DiagnosisStatus.FAILURE;
    }

    public String toString() {
        return this.cluster + ": " + this.status + System.lineSeparator() + this.checks.stream().map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    private boolean sameAsLastCheck(ConnectionCheck check) {
        if (this.checks.isEmpty()) {
            return false;
        }
        return ((ConnectionCheck)this.checks.get(this.checks.size() - 1)).equals((Object)check);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ConnectionDiagnosisBuilder builder() {
        return new ConnectionDiagnosisBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConnectionDiagnosisBuilder toBuilder() {
        return new ConnectionDiagnosisBuilder().status(this.status).cluster(this.cluster).checks(this.checks);
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosisStatus getStatus() {
        return this.status;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCluster() {
        return this.cluster;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ConnectionCheck> getChecks() {
        return this.checks;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionDiagnosis)) {
            return false;
        }
        ConnectionDiagnosis other = (ConnectionDiagnosis)o;
        DiagnosisStatus this$status = this.getStatus();
        DiagnosisStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$cluster = this.getCluster();
        String other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
            return false;
        }
        List this$checks = this.getChecks();
        List other$checks = other.getChecks();
        return !(this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DiagnosisStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
        List $checks = this.getChecks();
        result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
        return result;
    }

    @ConstructorProperties(value={"status", "cluster", "checks"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConnectionDiagnosis(@NotNull DiagnosisStatus status, @NotNull String cluster, @NotNull List<ConnectionCheck> checks) {
        this.status = status;
        this.cluster = cluster;
        this.checks = checks;
    }
}

