/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.conndiagnosis;

import com.hazelcast.cluster.Address;
import com.hazelcast.webmonitor.service.conndiagnosis.DiagnosisStatus;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ConnectionCheck {
    private final String shortDescription;
    private final String longDescription;
    private final DiagnosisStatus status;

    public static ConnectionCheck authenticationFailure() {
        return new ConnectionCheck("Authentication failure", "Possible reasons can be: <ul><li>The cluster name in the client config did not match the name in the server config</li><li>The credentials of the client config are not accepted by the server</li></ul>", DiagnosisStatus.FAILURE);
    }

    public static ConnectionCheck success(String shortDescription, String longDescription) {
        return new ConnectionCheck(shortDescription, longDescription, DiagnosisStatus.SUCCESS);
    }

    public static ConnectionCheck failure(String shortDescription, String longDescription) {
        return new ConnectionCheck(shortDescription, longDescription, DiagnosisStatus.FAILURE);
    }

    public static ConnectionCheck memberSideDisconnect(Collection<Address> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            throw new IllegalArgumentException("empty addresses");
        }
        String shortDescr = "Remote closed the connection";
        if (addresses.size() == 1) {
            Address addr2 = addresses.iterator().next();
            String longDescr = "The initial connection to " + addr2.getHost() + ":" + addr2.getPort() + " was closed by the other side";
            return ConnectionCheck.failure((String)shortDescr, (String)longDescr);
        }
        String addressList = addresses.stream().map(addr -> addr.getHost() + ":" + addr.getPort()).sorted().collect(Collectors.joining(", "));
        return ConnectionCheck.failure((String)shortDescr, (String)("The initial connections to " + addressList + " were closed by the other side"));
    }

    public static ConnectionCheck hostResolutionSucceeded(Collection<Address> possibleAddresses) {
        if (possibleAddresses == null || possibleAddresses.isEmpty()) {
            throw new IllegalArgumentException("null or empty address list");
        }
        List uniqueHostnames = possibleAddresses.stream().map(Address::getHost).sorted().distinct().collect(Collectors.toList());
        if (uniqueHostnames.size() == 1) {
            return new ConnectionCheck("Host resolved", "Host found: " + (String)uniqueHostnames.get(0), DiagnosisStatus.SUCCESS);
        }
        return new ConnectionCheck("Hosts resolved", "Hosts found: " + String.join((CharSequence)", ", uniqueHostnames), DiagnosisStatus.SUCCESS);
    }

    public static ConnectionCheck noOpenPortFound(Map<String, SortedSet<Integer>> tcpConnectionFailures) {
        if (tcpConnectionFailures == null || tcpConnectionFailures.isEmpty()) {
            throw new IllegalArgumentException("tcpConnectionFailures is empty - no connection attempt made?");
        }
        boolean isSingleHostFailure = tcpConnectionFailures.size() == 1;
        ArrayList<String> hostnames = new ArrayList<String>(tcpConnectionFailures.keySet());
        Collections.sort(hostnames);
        boolean multiplePorts = hostnames.size() > 1;
        ArrayList<String> hostFailureDescriptions = new ArrayList<String>(hostnames.size());
        StringBuilder longDescr = new StringBuilder("Could not establish connection on ");
        for (String hostName : hostnames) {
            String portRangeDescriptionPrefix;
            ArrayList ports = new ArrayList(tcpConnectionFailures.get(hostName));
            multiplePorts |= ports.size() > 1;
            Collections.sort(ports);
            String string = portRangeDescriptionPrefix = isSingleHostFailure ? "" : hostName + ":";
            if (ports.size() == 1) {
                hostFailureDescriptions.add(((Integer)ports.get(0)).toString());
                continue;
            }
            List portRangeDescriptions = ConnectionCheck.createPortRangeDescriptions(ports, (String)portRangeDescriptionPrefix);
            hostFailureDescriptions.add(String.join((CharSequence)", ", portRangeDescriptions));
        }
        longDescr.append(multiplePorts ? "any of ports " : "port ").append(String.join((CharSequence)", ", hostFailureDescriptions));
        return ConnectionCheck.failure((String)"No open port found", (String)longDescr.toString());
    }

    private static List<String> createPortRangeDescriptions(List<Integer> ports, String portRangeDescriptionPrefix) {
        List portRanges = ConnectionCheck.breakIntoRanges(ports);
        ArrayList<String> portRangeDescriptions = new ArrayList<String>(portRanges.size());
        for (List portRange : portRanges) {
            String portRangeDescr = portRange.size() == 1 ? ((Integer)portRange.get(0)).toString() : portRange.get(0) + "-" + portRange.get(portRange.size() - 1);
            portRangeDescriptions.add(portRangeDescriptionPrefix + portRangeDescr);
        }
        return portRangeDescriptions;
    }

    private static List<List<Integer>> breakIntoRanges(List<Integer> ports) {
        ArrayList<List<Integer>> ranges = new ArrayList<List<Integer>>();
        Integer prevPort = null;
        ArrayList<Integer> currentRange = new ArrayList<Integer>();
        for (Integer port : ports) {
            if (prevPort == null || prevPort == port - 1) {
                currentRange.add(port);
                prevPort = port;
                continue;
            }
            ranges.add(currentRange);
            currentRange = new ArrayList();
            currentRange.add(port);
            prevPort = port;
        }
        if (!currentRange.isEmpty()) {
            ranges.add(currentRange);
        }
        return ranges;
    }

    public String toString() {
        return this.status + ": " + this.shortDescription + " (" + this.longDescription + ")";
    }

    @ConstructorProperties(value={"shortDescription", "longDescription", "status"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConnectionCheck(String shortDescription, String longDescription, DiagnosisStatus status) {
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.status = status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosisStatus getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionCheck)) {
            return false;
        }
        ConnectionCheck other = (ConnectionCheck)o;
        String this$shortDescription = this.getShortDescription();
        String other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        DiagnosisStatus this$status = this.getStatus();
        DiagnosisStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $shortDescription = this.getShortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        DiagnosisStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }
}

