/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.model.sql.SettingModel;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.service.prometheus.PrometheusAuthAlreadyConfiguredException;
import com.hazelcast.webmonitor.service.prometheus.PrometheusAuthDetails;
import com.hazelcast.webmonitor.service.prometheus.PrometheusAuthDetailsStorage;
import com.hazelcast.webmonitor.utils.StringUtil;
import com.hazelcast.webmonitor.utils.XmlUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SettingsService
implements PrometheusAuthDetailsStorage {
    private static final String SETTING_NAME_LICENSE_KEY = "LICENSE_KEY";
    private static final String SETTING_NAME_HIDDEN_PROPERTIES = "HIDDEN_PROPERTIES";
    private static final String SETTING_NAME_MASKED_CONFIG_PROPERTIES = "MASKED_CONFIG_PROPERTIES";
    static final String SETTING_PROMETHEUS_AUTH_USERNAME = "PROMETHEUS_AUTH_USERNAME";
    private static final String SETTING_PROMETHEUS_AUTH_PASSWORD = "PROMETHEUS_AUTH_PASSWORD";
    private final SettingsDAO settingsDAO;

    public SettingsService(SettingsDAO settingsDAO) {
        this.settingsDAO = settingsDAO;
    }

    public void saveLicenseKey(String key) {
        this.saveStringProperty(SETTING_NAME_LICENSE_KEY, key);
    }

    public Optional<String> getLicenseKey() {
        return this.getStringProperty(SETTING_NAME_LICENSE_KEY);
    }

    public void saveHiddenProperties(List<String> hiddenProperties) {
        this.saveCommaSeparatedListProperty(SETTING_NAME_HIDDEN_PROPERTIES, hiddenProperties);
    }

    public List<String> getHiddenProperties() {
        return this.getCommaSeparatedListProperty(SETTING_NAME_HIDDEN_PROPERTIES);
    }

    public void saveMaskedConfigProperties(List<String> maskedConfigProperties) {
        maskedConfigProperties.forEach(xpath -> {
            if (!XmlUtil.isValidXPath((String)xpath)) {
                throw new IllegalArgumentException(String.format("Invalid XPath for a masked config property: %s.", xpath));
            }
        });
        this.saveCommaSeparatedListProperty(SETTING_NAME_MASKED_CONFIG_PROPERTIES, maskedConfigProperties);
    }

    public List<String> getMaskedConfigProperties() {
        return this.getCommaSeparatedListProperty(SETTING_NAME_MASKED_CONFIG_PROPERTIES);
    }

    private void saveStringProperty(String propertyName, String propertyValue) {
        this.settingsDAO.insertOrUpdate(new SettingModel(propertyName, propertyValue));
    }

    private Optional<String> getStringProperty(String propertyName) {
        return this.settingsDAO.findByName(propertyName).map(SettingModel::getValue);
    }

    private void saveCommaSeparatedListProperty(String propertyName, List<String> inputValues) {
        inputValues.forEach(inputValue -> {
            if (StringUtil.isNullOrEmptyAfterTrim((String)inputValue)) {
                throw new IllegalArgumentException("Empty properties are not allowed.");
            }
        });
        String propertyValue = String.join((CharSequence)",", inputValues);
        this.settingsDAO.insertOrUpdate(new SettingModel(propertyName, propertyValue));
    }

    private List<String> getCommaSeparatedListProperty(String propertyName) {
        return this.settingsDAO.findByName(propertyName).map(SettingModel::getValue).filter(s -> !s.isEmpty()).map(s -> Arrays.asList(s.split(","))).orElse(Collections.emptyList());
    }

    public void savePrometheusAuthDetails(PrometheusAuthDetails authDetails) throws PrometheusAuthAlreadyConfiguredException {
        if (this.getPrometheusAuthDetails().isPresent()) {
            throw new PrometheusAuthAlreadyConfiguredException();
        }
        this.settingsDAO.insertOrUpdate(new SettingModel(SETTING_PROMETHEUS_AUTH_USERNAME, authDetails.getUserName()));
        this.settingsDAO.insertOrUpdate(new SettingModel(SETTING_PROMETHEUS_AUTH_PASSWORD, authDetails.getPassword()));
    }

    public Optional<PrometheusAuthDetails> getPrometheusAuthDetails() {
        Optional maybeUsername = this.settingsDAO.findByName(SETTING_PROMETHEUS_AUTH_USERNAME);
        Optional maybePassword = this.settingsDAO.findByName(SETTING_PROMETHEUS_AUTH_PASSWORD);
        if (maybeUsername.isPresent() != maybePassword.isPresent()) {
            throw new IllegalStateException("Inconsistent prometheus authentication settings. It can be reset by running mc-conf security reset");
        }
        return maybeUsername.map(settingModel -> new PrometheusAuthDetails(settingModel.getValue(), ((SettingModel)maybePassword.get()).getValue()));
    }

    public void resetPrometheusAuthDetails() {
        this.settingsDAO.deleteByName(SETTING_PROMETHEUS_AUTH_USERNAME);
        this.settingsDAO.deleteByName(SETTING_PROMETHEUS_AUTH_PASSWORD);
    }
}

