/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.HeapMemoryDistributionDTO;
import com.hazelcast.webmonitor.controller.dto.MigrationStateDTO;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.NoMasterMemberApiException;
import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.imdg.MapMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.MemberMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.imdg.PartitionServiceMetricsQueryFactory;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.metrics.MetricsService;
import com.hazelcast.webmonitor.utils.MemberMap;
import com.hazelcast.webmonitor.utils.StatisticsUtil;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ClusterStatsService {
    private static final long LOOKUP_INTERVAL_MS = 60000L;
    private final MetricsService metricsService;
    private final StateManager stateManager;
    private final Clock clock;

    public ClusterStatsService(MetricsService metricsService, StateManager stateManager, Clock clock) {
        this.metricsService = metricsService;
        this.stateManager = stateManager;
        this.clock = clock;
    }

    public HeapMemoryDistributionDTO getHeapMemoryDistribution(String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            throw new NoClusterApiException(cluster);
        }
        long end = this.clock.currentTimeMillis();
        long start = end - 60000L;
        long committedHeap = 0L;
        long usedHeap = 0L;
        long mapsHeapCost = 0L;
        MemberMap memberStates = state.getTimedMemberStates();
        for (String member : state.getMembers()) {
            TimedMemberState timedMemberState = (TimedMemberState)memberStates.get(member);
            if (timedMemberState != null && timedMemberState.isLite()) continue;
            MemberMetricsQueryFactory memberMetricsQueryFactory = new MemberMetricsQueryFactory.Builder().cluster(cluster).member(member).start(start).end(end).build();
            committedHeap += this.metricsService.queryLatestRaw(memberMetricsQueryFactory.committedHeapQuery()).map(DataPointAware::getValue).orElse(0L).longValue();
            usedHeap += this.metricsService.queryLatestRaw(memberMetricsQueryFactory.usedHeapQuery()).map(DataPointAware::getValue).orElse(0L).longValue();
            for (String map : state.getInstanceNames(InstanceType.MAP)) {
                MapMetricsQueryFactory queryFactory = (MapMetricsQueryFactory)new MapMetricsQueryFactory.Builder().member(member).cluster(cluster).start(start).end(end).name(map).build();
                Query mapHeapCostQuery = queryFactory.heapCostQuery();
                mapsHeapCost += this.metricsService.queryLatestRaw(mapHeapCostQuery).map(DataPointAware::getValue).orElse(0L).longValue();
            }
        }
        return new HeapMemoryDistributionDTO(committedHeap, usedHeap, mapsHeapCost, StatisticsUtil.asPercents((double)mapsHeapCost, (double)committedHeap), StatisticsUtil.asPercents((double)(usedHeap - mapsHeapCost), (double)committedHeap), StatisticsUtil.asPercents((double)(committedHeap - usedHeap), (double)committedHeap));
    }

    public MigrationStateDTO getClusterMigrationState(String cluster) {
        long now = this.clock.currentTimeMillis();
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return MigrationStateDTO.NO_MIGRATION_DATA;
        }
        List unsafeMembers = state.getUnsafeMembers();
        String master = state.getMasterState().map(memberState -> memberState.getMemberState().getAddress()).orElseThrow(() -> new NoMasterMemberApiException(cluster));
        PartitionServiceMetricsQueryFactory queryFactory = new PartitionServiceMetricsQueryFactory.Builder().cluster(cluster).member(master).start(now - 60000L).end(now).build();
        long migrationQueueSize = this.metricsService.queryLatestRaw(queryFactory.migrationQueueSizeQuery()).map(DataPointAware::getValue).orElse(0L);
        return new MigrationStateDTO(unsafeMembers, migrationQueueSize);
    }
}

