/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.service.ClientNearCacheRegistry;
import com.hazelcast.webmonitor.service.Clock;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class ClientNearCacheRegistry {
    private final Set<RegistryElement> registry;

    public ClientNearCacheRegistry(Clock clock, int maxSize, int ttlMinutes) {
        Cache cache = Caffeine.newBuilder().expireAfterWrite((long)ttlMinutes, TimeUnit.MINUTES).maximumSize((long)maxSize).ticker(() -> ((Clock)clock).nanoTime()).build();
        this.registry = Collections.newSetFromMap(cache.asMap());
    }

    public void register(String cluster, String clientUuid, String clientName, String structName, InstanceType structType) {
        this.registry.add(new RegistryElement(cluster, clientUuid, clientName, structName, structType));
    }

    public SortedSet<ClientData> getClientsByStruct(String cluster, String structName, InstanceType structType) {
        TreeSet<ClientData> clients = new TreeSet<ClientData>();
        for (RegistryElement registryElement : this.registry) {
            if (!cluster.equals(registryElement.cluster) || registryElement.structType != structType || !structName.equals(registryElement.structName)) continue;
            clients.add(new ClientData(registryElement.clientName, registryElement.clientUuid));
        }
        return clients;
    }

    public SortedSet<String> getStructsByClient(String cluster, String clientUuid, InstanceType structType) {
        TreeSet<String> structs = new TreeSet<String>();
        for (RegistryElement registryElement : this.registry) {
            if (!cluster.equals(registryElement.cluster) || registryElement.structType != structType || !clientUuid.equals(registryElement.clientUuid)) continue;
            structs.add(registryElement.structName);
        }
        return structs;
    }

    int size() {
        return this.registry.size();
    }
}

