/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.NodeLimitStatus;
import com.hazelcast.webmonitor.service.StateManager;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
public class CentralManager
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CentralManager.class);
    public static final int UNLICENSED_CLUSTER_NODE_LIMIT = 3;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(4, new ThreadFactoryBuilder().setNameFormat("CentralManager-%d").build());
    private static final Logger STATE_PROCESSING_ERROR_LOGGER = RateLimitedLog.withRateLimit((Logger)log).maxRate(1).every(Duration.of(1L, ChronoUnit.MINUTES)).build();
    private final StateManager stateManager;
    private final LicenseManager licenseManager;
    private final NodeLimitStatus nodeLimitStatus;
    private final Notifier notifier;

    public static String[] extractClusterAndTime(String key) {
        String[] res = new String[2];
        int ind = key.lastIndexOf(95);
        res[0] = key.substring(0, ind);
        res[1] = key.substring(ind + 1);
        return res;
    }

    synchronized void addMemberState(TimedMemberState memberState, String cluster) {
        List errors;
        if (this.licenseManager.isAboveMemberLimit(memberState.getMembers().size())) {
            this.nodeLimitStatus.exceedsNodeLimit(cluster);
            memberState.setMemberState(memberState.getMemberState().toNodeLimitExceededView());
        } else {
            this.nodeLimitStatus.underNodeLimit(cluster);
        }
        long now = System.currentTimeMillis();
        memberState.setTime(now);
        AllState allState = this.stateManager.getLatestStateIfSameInterval(cluster, now);
        if (allState == null) {
            allState = new AllState();
            long time = StateManager.floorTimeToInterval((long)now);
            allState.setTime(time);
        }
        this.updateAllStateFromLatestState(cluster, now, allState);
        if (memberState.isMaster()) {
            SortedSet liveMemberList = memberState.getMembers();
            for (MemberState state : allState.getMemberStates()) {
                String address = state.getAddress();
                if (liveMemberList.contains(address)) continue;
                allState.removeMemberState(address);
            }
        }
        if (!(errors = allState.addState(memberState)).isEmpty()) {
            String memberAddress = memberState.getMemberState().getAddress();
            String msg = errors.stream().collect(Collectors.joining(" ", "Unable to process member state received from [" + memberAddress + "]. ", " Please check logs for the details."));
            STATE_PROCESSING_ERROR_LOGGER.warn(msg);
            this.notifier.signal(Note.Matter.RECEIVED_MALFORMED_METRICS.on(cluster, msg));
        }
        this.stateManager.cacheLatestState(cluster, allState);
    }

    private void updateAllStateFromLatestState(String cluster, long now, AllState allState) {
        AllState latestState = this.stateManager.getLatestState(cluster);
        if (latestState != null) {
            for (TimedMemberState timedMemberState : latestState.getTimedMemberStates()) {
                TimedMemberState latest = timedMemberState.clone();
                latest.setTime(now);
                allState.addState(latest);
            }
        }
    }

    ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public void close() {
        this.scheduledExecutorService.shutdown();
    }

    @ConstructorProperties(value={"stateManager", "licenseManager", "nodeLimitStatus", "notifier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CentralManager(StateManager stateManager, LicenseManager licenseManager, NodeLimitStatus nodeLimitStatus, Notifier notifier) {
        this.stateManager = stateManager;
        this.licenseManager = licenseManager;
        this.nodeLimitStatus = nodeLimitStatus;
        this.notifier = notifier;
    }
}

