/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.controller.dto.cp.CPDataStructureListingDTO;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tags;
import com.hazelcast.webmonitor.model.CPInstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.service.CPStatsRegistry;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.StateManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class CPStatsRegistry {
    public static final String ID_TAG = "id";
    public static final String CLUSTER_TAG = "mc:cluster";
    public static final String MEMBER_TAG = "mc:member";
    public static final String GROUP_TAG = "group";
    public static final String SESSION_ID_TAG = "sessionId";
    public static final String SESSION_ENDPOINT_TAG = "endpoint";
    public static final String SESSION_ENDPOINT_TYPE_TAG = "endpointType";
    public static final String SESSION_ID_METRIC = "cp.session.id";
    public static final String SESSION_ENDPOINT_METRIC = "cp.session.endpoint";
    public static final String SESSION_ENDPOINT_TYPE_METRIC = "cp.session.endpointType";
    public static final String SESSION_CREATION_TIME_METRIC = "cp.session.creationTime";
    public static final String SESSION_EXPIRATION_TIME_METRIC = "cp.session.expirationTime";
    public static final String SESSION_VERSION_METRIC = "cp.session.version";
    private final Set<DataStructureRecord> knownDataStructures;
    private final Cache<String, GroupRecord> knownGroups;
    private final Cache<String, SessionRecord> knownSessions;
    private final StateManager stateManager;

    public CPStatsRegistry(StateManager stateManager, Clock clock, int maxSize, int ttlMinutes) {
        this.stateManager = stateManager;
        Cache knownStructsCache = Caffeine.newBuilder().expireAfterWrite((long)ttlMinutes, TimeUnit.MINUTES).maximumSize((long)maxSize).ticker(() -> ((Clock)clock).nanoTime()).build();
        this.knownDataStructures = Collections.newSetFromMap(knownStructsCache.asMap());
        this.knownGroups = Caffeine.newBuilder().expireAfterWrite((long)ttlMinutes, TimeUnit.MINUTES).maximumSize((long)maxSize).ticker(() -> ((Clock)clock).nanoTime()).build();
        this.knownSessions = Caffeine.newBuilder().expireAfterWrite((long)ttlMinutes, TimeUnit.MINUTES).maximumSize((long)maxSize).ticker(() -> ((Clock)clock).nanoTime()).build();
    }

    public void registerDataStructure(String cluster, CPInstanceType structType, String structName, String group) {
        this.knownDataStructures.add(DataStructureRecord.builder().cluster(cluster).structType(structType).structName(structName).group(group).build());
    }

    public void registerGroup(String cluster, String groupId, String groupName, String member, String memberRole) {
        String cacheKey = cluster + groupId + groupName;
        this.knownGroups.asMap().compute(cacheKey, (k, v) -> {
            GroupRecord groupRecord = v;
            if (groupRecord == null) {
                groupRecord = GroupRecord.builder().cluster(cluster).groupId(groupId).groupName(groupName).members(new TreeMap()).build();
            }
            GroupRecord.access$500((GroupRecord)groupRecord).put(member, memberRole);
            return groupRecord;
        });
    }

    public void processSessionDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        Tags tags = dataPoint.getTags();
        Optional<String> idOptional = tags.getTag("id").map(Tags.Tag::getValue);
        if (!idOptional.isPresent()) {
            return;
        }
        String id = idOptional.get();
        String cluster = memberIdent.getClusterName();
        String member = memberIdent.getMemberAddress();
        String cacheKey = cluster + member + id;
        this.knownSessions.asMap().compute(cacheKey, (k, v) -> {
            SessionRecord sessionRecord = v;
            if (sessionRecord == null) {
                sessionRecord = SessionRecord.builder().cluster(cluster).member(member).id(id).build();
            }
            tags.getTag("sessionId").map(Tags.Tag::getValue).ifPresent(arg_0 -> ((SessionRecord)sessionRecord).setSessionId(arg_0));
            tags.getTag("group").map(Tags.Tag::getValue).ifPresent(arg_0 -> ((SessionRecord)sessionRecord).setGroup(arg_0));
            String endpoint = tags.getTag("endpoint").map(Tags.Tag::getValue).orElse(null);
            if (endpoint != null) {
                sessionRecord.setEndpoint(endpoint);
                sessionRecord.setEndpointName(this.getMatchingEndpointName(cluster, endpoint));
            }
            tags.getTag("endpointType").map(Tags.Tag::getValue).ifPresent(arg_0 -> ((SessionRecord)sessionRecord).setEndpointType(arg_0));
            if (dataPoint.getName().equals("cp.session.creationTime")) {
                sessionRecord.setCreationTime(dataPoint.getValue());
            }
            if (dataPoint.getName().equals("cp.session.expirationTime")) {
                sessionRecord.setExpirationTime(dataPoint.getValue());
            }
            if (dataPoint.getName().equals("cp.session.version")) {
                sessionRecord.setVersion(dataPoint.getValue());
            }
            return sessionRecord;
        });
    }

    private String getMatchingEndpointName(String cluster, String endpoint) {
        Map clients = this.stateManager.getClients(cluster);
        return clients.values().stream().filter(client -> {
            String endpointFromClientInfo = client.getAddress().replace(client.getCanonicalHostName(), String.format("[%s]", client.getIpAddress()));
            return endpointFromClientInfo.equals(endpoint);
        }).findFirst().map(ClientEndPointDTO::getName).orElse(null);
    }

    public List<SessionRecord> getKnownSessions(String cluster) {
        return this.knownSessions.asMap().values().stream().filter(sessionRecord -> cluster.equals(sessionRecord.cluster)).collect(Collectors.toList());
    }

    public List<CPDataStructureListingDTO> getKnownStructsByType(String cluster, CPInstanceType structType) {
        return this.knownDataStructures.stream().filter(rec -> cluster.equals(DataStructureRecord.access$300((DataStructureRecord)rec)) && structType.equals((Object)DataStructureRecord.access$400((DataStructureRecord)rec))).map(rec -> CPDataStructureListingDTO.builder().name(DataStructureRecord.access$200((DataStructureRecord)rec)).group(DataStructureRecord.access$100((DataStructureRecord)rec)).build()).collect(Collectors.toList());
    }

    public List<GroupRecord> getKnownGroups(String cluster) {
        return this.knownGroups.asMap().values().stream().filter(groupRecord -> cluster.equals(GroupRecord.access$000((GroupRecord)groupRecord))).collect(Collectors.toList());
    }
}

