/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.ldap;

import com.hazelcast.webmonitor.model.LdapUser;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToAuthoritiesMapper;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class LdapUserDetailsContextMapper
implements UserDetailsContextMapper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapUserDetailsContextMapper.class);
    private final LdapUserDetailsMapper ldapUserDetailsMapper = new LdapUserDetailsMapper();
    private final GroupsToRolesMappingConfig config;

    public LdapUserDetailsContextMapper(GroupsToRolesMappingConfig config) {
        this.ldapUserDetailsMapper.setRolePrefix("");
        this.config = config;
    }

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        log.debug("Mapping user [{}] from LDAP context", (Object)username);
        LdapUserDetails userDetails = (LdapUserDetails)this.ldapUserDetailsMapper.mapUserFromContext(ctx, username, authorities);
        Set stringAuthorities = userDetails.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        return LdapUser.create((LdapUserDetails)userDetails, (Collection)GroupsToAuthoritiesMapper.mapGroupsToAuthorities(stringAuthorities, (GroupsToRolesMappingConfig)this.config));
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
        throw new UnsupportedOperationException("Saving user to LDAP server is not supported!");
    }
}

