/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.activedirectory;

import com.hazelcast.webmonitor.security.spi.impl.activedirectory.ActiveDirectoryAuthenticationProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticationProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ActiveDirectoryAuthenticationProvider
extends AbstractLdapAuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveDirectoryAuthenticationProvider.class);
    private static final Pattern SUB_ERROR_CODE = Pattern.compile(".*data\\s([0-9a-f]{3,4}).*");
    private static final int USERNAME_NOT_FOUND = 1317;
    private static final int INVALID_PASSWORD = 1326;
    private static final int NOT_PERMITTED = 1328;
    private static final int PASSWORD_EXPIRED = 1330;
    private static final int ACCOUNT_DISABLED = 1331;
    private static final int ACCOUNT_EXPIRED = 1793;
    private static final int PASSWORD_NEEDS_RESET = 1907;
    private static final int ACCOUNT_LOCKED = 1909;
    private static final String SECURITY_GROUP_FLAG = String.valueOf(Integer.MIN_VALUE);
    private static final String LDAP_MATCHING_RULE_BIT_AND = ":1.2.840.113556.1.4.803:";
    private static final String LDAP_MATCHING_RULE_IN_CHAIN = ":1.2.840.113556.1.4.1941:";
    private static final String IS_GROUP = "(objectCategory=group)";
    private static final String IS_SECURITY_ENABLED = "(groupType:1.2.840.113556.1.4.803:=" + SECURITY_GROUP_FLAG + ")";
    private final String domain;
    private final String rootDn;
    private final String url;
    private final boolean nestedGroupSearch;
    private final int connTimeout;
    private boolean convertSubErrorCodesToExceptions;
    private String searchFilter = "(&(objectClass=user)(userPrincipalName={0}))";
    private final ContextFactory contextFactory = new ContextFactory();

    ActiveDirectoryAuthenticationProvider(String domain, String url, boolean nestedGroupSearch, int connTimeout) {
        Assert.isTrue((boolean)StringUtils.hasText((String)url), (String)"Url cannot be empty");
        this.domain = StringUtils.hasText((String)domain) ? domain.toLowerCase() : null;
        this.url = url;
        this.rootDn = this.domain == null ? null : this.rootDnFromDomain(this.domain);
        this.nestedGroupSearch = nestedGroupSearch;
        this.connTimeout = connTimeout;
    }

    protected DirContextOperations doAuthentication(UsernamePasswordAuthenticationToken auth) {
        String username = auth.getName();
        String password = (String)auth.getCredentials();
        DirContext ctx = this.bindAsUser(username, password);
        try {
            DirContextOperations dirContextOperations = this.searchForUser(ctx, username);
            return dirContextOperations;
        }
        catch (NamingException e) {
            LOGGER.error("Failed to locate directory entry for authenticated user: {}", (Object)username, (Object)e);
            throw this.badCredentials((Throwable)e);
        }
        finally {
            LdapUtils.closeContext((DirContext)ctx);
        }
    }

    protected Collection<? extends GrantedAuthority> loadUserAuthorities(DirContextOperations userData, String username, String password) {
        String[] groups = userData.getStringAttributes("memberOf");
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        if (groups == null) {
            LOGGER.debug("No values for 'memberOf' attribute.");
        } else {
            LOGGER.debug("'memberOf' attribute values: {}", Arrays.asList(groups));
            for (String group : groups) {
                authorities.add(new SimpleGrantedAuthority(new DistinguishedName(group).removeLast().getValue()));
            }
        }
        LdapContextSource ldapContextSource = this.createLdapContextSource(username, password);
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)ldapContextSource);
        ldapTemplate.setIgnorePartialResultException(true);
        if (this.nestedGroupSearch) {
            Set additionalRoles = this.getAdditionalRoles(userData, ldapTemplate);
            authorities.addAll(additionalRoles);
        }
        return authorities;
    }

    private LdapContextSource createLdapContextSource(String username, String password) {
        LdapContextSource ldapContextSource = new LdapContextSource();
        ldapContextSource.setUrl(this.url);
        ldapContextSource.setUserDn(this.createBindPrincipal(username));
        ldapContextSource.setPassword(password);
        ldapContextSource.setBase(this.rootDn);
        ldapContextSource.setReferral("follow");
        ldapContextSource.afterPropertiesSet();
        return ldapContextSource;
    }

    private Set<GrantedAuthority> getAdditionalRoles(DirContextOperations userData, LdapTemplate ldapTemplate) {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        String filter = "(&(objectCategory=group)" + IS_SECURITY_ENABLED + "(member" + LDAP_MATCHING_RULE_IN_CHAIN + "={0}))";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        LdapQuery ldapQuery = LdapQueryBuilder.query().filter(filter, new Object[]{userData.getDn()});
        List roleList = new ArrayList();
        try {
            roleList = ldapTemplate.search("", ldapQuery.filter().toString(), searchControls, attrs -> {
                Attribute cn = attrs.get("cn");
                if (cn != null) {
                    return cn.get().toString();
                }
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("LDAP search of nested groups failed.", (Throwable)e);
        }
        for (String role : roleList) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
        }
        LOGGER.debug("Authorities after LDAP search of nested groups: {}", authorities);
        return authorities;
    }

    private DirContext bindAsUser(String username, String password) {
        LOGGER.debug("Binding as user {}", (Object)username);
        String bindUrl = this.url;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        String bindPrincipal = this.createBindPrincipal(username);
        env.put("java.naming.security.principal", bindPrincipal);
        env.put("java.naming.provider.url", bindUrl);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.factory.object", DefaultDirObjectFactory.class.getName());
        env.put("java.naming.referral", "ignore");
        env.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(this.connTimeout));
        env.put("com.sun.jndi.ldap.read.timeout", String.valueOf(this.connTimeout));
        try {
            return this.contextFactory.createContext(env);
        }
        catch (AuthenticationException | OperationNotSupportedException e) {
            this.handleBindException(bindPrincipal, e);
            throw this.badCredentials((Throwable)e);
        }
        catch (NamingException e) {
            throw LdapUtils.convertLdapException((NamingException)e);
        }
    }

    private void handleBindException(String bindPrincipal, NamingException exception) {
        LOGGER.debug("Authentication for {} failed.", (Object)bindPrincipal, (Object)exception);
        int subErrorCode = this.parseSubErrorCode(exception.getMessage());
        if (subErrorCode <= 0) {
            LOGGER.debug("Failed to locate AD-specific sub-error code in message");
            return;
        }
        LOGGER.info("Active Directory authentication failed: {}", (Object)this.subCodeToLogMessage(subErrorCode));
        if (this.convertSubErrorCodesToExceptions) {
            this.raiseExceptionForErrorCode(subErrorCode, exception);
        }
    }

    private int parseSubErrorCode(String message) {
        Matcher m = SUB_ERROR_CODE.matcher(message);
        if (m.matches()) {
            return Integer.parseInt(m.group(1), 16);
        }
        return -1;
    }

    private void raiseExceptionForErrorCode(int code, NamingException exception) {
        switch (code) {
            case 1330: {
                throw new CredentialsExpiredException(this.messages.getMessage("LdapAuthenticationProvider.credentialsExpired", "User credentials have expired"), (Throwable)exception);
            }
            case 1331: {
                throw new DisabledException(this.messages.getMessage("LdapAuthenticationProvider.disabled", "User is disabled"), (Throwable)exception);
            }
            case 1793: {
                throw new AccountExpiredException(this.messages.getMessage("LdapAuthenticationProvider.expired", "User account has expired"), (Throwable)exception);
            }
            case 1909: {
                throw new LockedException(this.messages.getMessage("LdapAuthenticationProvider.locked", "User account is locked"), (Throwable)exception);
            }
        }
        throw this.badCredentials((Throwable)exception);
    }

    private String subCodeToLogMessage(int code) {
        switch (code) {
            case 1317: {
                return "User was not found in directory";
            }
            case 1326: {
                return "Supplied password was invalid";
            }
            case 1328: {
                return "User not permitted to logon at this time";
            }
            case 1330: {
                return "Password has expired";
            }
            case 1331: {
                return "Account is disabled";
            }
            case 1793: {
                return "Account expired";
            }
            case 1907: {
                return "User must reset password";
            }
            case 1909: {
                return "Account locked";
            }
        }
        return "Unknown (error code " + Integer.toHexString(code) + ")";
    }

    private BadCredentialsException badCredentials() {
        return new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
    }

    private BadCredentialsException badCredentials(Throwable cause) {
        return (BadCredentialsException)this.badCredentials().initCause(cause);
    }

    private DirContextOperations searchForUser(DirContext context, String username) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String bindPrincipal = this.createBindPrincipal(username);
        String searchRoot = this.rootDn != null ? this.rootDn : this.searchRootFromPrincipal(bindPrincipal);
        try {
            LOGGER.debug("Searching for bindPrincipal {} and user {}. Search root = {}.", new Object[]{bindPrincipal, username, searchRoot});
            return SpringSecurityLdapTemplate.searchForSingleEntryInternal((DirContext)context, (SearchControls)searchControls, (String)searchRoot, (String)this.searchFilter, (Object[])new Object[]{bindPrincipal, username});
        }
        catch (IncorrectResultSizeDataAccessException incorrectResults) {
            if (incorrectResults.getActualSize() != 0) {
                throw incorrectResults;
            }
            UsernameNotFoundException userNameNotFoundException = new UsernameNotFoundException("User " + username + " not found in directory.", (Throwable)incorrectResults);
            throw this.badCredentials((Throwable)userNameNotFoundException);
        }
    }

    private String searchRootFromPrincipal(String bindPrincipal) {
        int atChar = bindPrincipal.lastIndexOf(64);
        if (atChar < 0) {
            LOGGER.debug("User principal '{}' does not contain the domain, and no domain has been configured", (Object)bindPrincipal);
            throw this.badCredentials();
        }
        return this.rootDnFromDomain(bindPrincipal.substring(atChar + 1));
    }

    private String rootDnFromDomain(String domain) {
        String[] tokens = StringUtils.tokenizeToStringArray((String)domain, (String)".");
        StringBuilder root = new StringBuilder();
        for (String token : tokens) {
            if (root.length() > 0) {
                root.append(',');
            }
            root.append("dc=").append(token);
        }
        return root.toString();
    }

    private String createBindPrincipal(String username) {
        LOGGER.debug("Creating bind principal for {}", (Object)username);
        String bindPrincipal = this.domain == null || username.contains("@") ? username : username + "@" + this.domain;
        LOGGER.debug("Bind principal = {}", (Object)bindPrincipal);
        return bindPrincipal;
    }

    public void setConvertSubErrorCodesToExceptions(boolean convertSubErrorCodesToExceptions) {
        this.convertSubErrorCodesToExceptions = convertSubErrorCodesToExceptions;
    }

    public void setSearchFilter(String searchFilter) {
        Assert.hasText((String)searchFilter, (String)"searchFilter must have text");
        this.searchFilter = searchFilter;
    }
}

