/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.UserModel;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Service;

@Service
public class UserDAO {
    private final Jdbi jdbi;

    public UserDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public void updateLoginTime(String username, OffsetDateTime timestamp) {
        this.jdbi.useHandle(handle -> {
            UserModel user = this.getUserTx(handle, username).orElseGet(() -> this.insertTx(handle, username));
            user.setLastLoginTime(user.getCurrentLoginTime());
            user.setCurrentLoginTime(timestamp);
            this.updateTx(handle, user);
        });
    }

    private Optional<UserModel> getUser(String username) {
        return (Optional)this.jdbi.withHandle(handle -> this.getUserTx(handle, username));
    }

    private Optional<UserModel> getUserTx(Handle handle, String username) {
        return ((Query)handle.createQuery("select username, last_login_time, current_login_time from users where username = :username").bind("username", username)).mapToBean(UserModel.class).findFirst();
    }

    public UserModel insert(String username) {
        return (UserModel)this.jdbi.withHandle(handle -> this.insertTx(handle, username));
    }

    public UserModel insertTx(Handle handle, String username) {
        UserModel newUser = new UserModel();
        newUser.setUsername(username);
        this.insertTx(handle, newUser);
        return newUser;
    }

    private void insertTx(Handle handle, UserModel user) {
        ((Update)((Update)((Update)handle.createUpdate("insert into users (username, last_login_time, current_login_time) values (:username, :lastLoginTime, :currentLoginTime)").bind("username", user.getUsername())).bind("lastLoginTime", (Object)user.getLastLoginTime())).bind("currentLoginTime", (Object)user.getCurrentLoginTime())).execute();
    }

    private int updateTx(Handle handle, UserModel user) {
        return ((Update)((Update)((Update)handle.createUpdate("update users set last_login_time = :lastLoginTime, current_login_time = :currentLoginTime where username = :username").bind("lastLoginTime", (Object)user.getLastLoginTime())).bind("currentLoginTime", (Object)user.getCurrentLoginTime())).bind("username", user.getUsername())).execute();
    }

    public Optional<OffsetDateTime> getLastLoginTime(String username) {
        return this.getUser(username).map(UserModel::getLastLoginTime);
    }

    public void deleteTx(Handle handle, String username) {
        ((Update)handle.createUpdate("delete from users where username = :username").bind("username", username)).execute();
    }
}

