/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.MemberModel;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Service;

@Service
public class MemberDAO {
    private final Jdbi jdbi;

    public MemberDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public List<MemberModel> findAllByCluster(String cluster) {
        return (List)this.jdbi.withHandle(handle -> ((Query)handle.createQuery("select * from members where cluster = :cluster order by address").bind("cluster", cluster)).mapToBean(MemberModel.class).list());
    }

    public List<MemberModel> findAllByClusterAndTime(String cluster, OffsetDateTime time) {
        return (List)this.jdbi.withHandle(handle -> ((Query)((Query)handle.createQuery("select * from members where cluster = :cluster and       first_seen_at <= :time and ifnull(last_seen_at, :time) >= :time order by address").bind("cluster", cluster)).bind("time", (Object)time)).mapToBean(MemberModel.class).list());
    }

    public Optional<MemberModel> findByClusterAndAddress(String cluster, String address) {
        return (Optional)this.jdbi.withHandle(handle -> this.findByClusterAndAddressTx(handle, cluster, address));
    }

    public List<MemberModel> findMembersInInterval(String cluster, OffsetDateTime from, OffsetDateTime to) {
        return (List)this.jdbi.withHandle(handle -> ((Query)((Query)((Query)handle.createQuery("SELECT * FROM members  WHERE ((:from <= first_seen_at AND first_seen_at <= :to) OR (:from <= nvl(last_seen_at, now()) AND nvl(last_seen_at, now()) <= :to) OR (first_seen_at <= :from AND :to <= nvl(last_seen_at, now()))) AND cluster = :cluster").bind("from", (Object)from)).bind("to", (Object)to)).bind("cluster", cluster)).mapToBean(MemberModel.class).list());
    }

    public void insertOrUpdate(MemberModel member) {
        this.jdbi.useTransaction(handle -> {
            Optional existingMember = this.findByClusterAndAddressTx(handle, member.getCluster(), member.getAddress());
            if (existingMember.isPresent()) {
                this.updateTx(handle, member);
            } else {
                this.insertTx(handle, member);
            }
        });
    }

    private Optional<MemberModel> findByClusterAndAddressTx(Handle handle, String cluster, String address) {
        return ((Query)((Query)handle.createQuery("select * from members where cluster = :cluster and address = :address").bind("cluster", cluster)).bind("address", address)).mapToBean(MemberModel.class).findFirst();
    }

    private int updateTx(Handle handle, MemberModel member) {
        return ((Update)((Update)((Update)handle.createUpdate("update members set last_seen_at = :lastSeenAt WHERE cluster = :cluster AND address = :address").bind("cluster", member.getCluster())).bind("address", member.getAddress())).bind("lastSeenAt", (Object)member.getLastSeenAt())).execute();
    }

    private void insertTx(Handle handle, MemberModel member) {
        ((Update)((Update)((Update)((Update)handle.createUpdate("insert into members (cluster, address, first_seen_at, last_seen_at) values (:cluster, :address, :firstSeenAt, :lastSeenAt)").bind("cluster", member.getCluster())).bind("address", member.getAddress())).bind("firstSeenAt", (Object)member.getFirstSeenAt())).bind("lastSeenAt", (Object)member.getLastSeenAt())).execute();
    }

    public void updateLastSeenAt(String cluster, String address, OffsetDateTime lastSeenAt) {
        this.jdbi.withHandle(handle -> this.updateLastSeenAtTx(handle, cluster, address, lastSeenAt));
    }

    public void updateLastSeenAt(String cluster, List<String> addresses, OffsetDateTime lastSeenAt) {
        if (addresses.isEmpty()) {
            return;
        }
        this.jdbi.withHandle(handle -> ((Update)((Update)((Update)handle.createUpdate("update members set last_seen_at = :lastSeenAt where cluster = :cluster and address in (<addresses>) and last_seen_at is null").bindList("addresses", (Iterable)addresses)).bind("cluster", cluster)).bind("lastSeenAt", (Object)lastSeenAt)).execute());
    }

    private int updateLastSeenAtTx(Handle handle, String cluster, String address, OffsetDateTime lastSeenAt) {
        return ((Update)((Update)((Update)handle.createUpdate("update members set last_seen_at = :lastSeenAt where cluster = :cluster and address = :address and last_seen_at is null").bind("cluster", cluster)).bind("address", address)).bind("lastSeenAt", (Object)lastSeenAt)).execute();
    }

    public void deleteAllByCluster(String cluster) {
        this.jdbi.useHandle(handle -> this.deleteAllByClusterTx(handle, cluster));
    }

    public void deleteAllByClusterTx(Handle handle, String cluster) {
        ((Update)handle.createUpdate("delete from members where cluster = :cluster").bind("cluster", cluster)).execute();
    }
}

