/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.serde;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class ByteArrayInput {
    private byte[] buf;
    private int pos;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="method is called from well-behaving modules")
    public void resetDataAndPosition(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
    }

    public boolean readBoolean() {
        return this.buf[this.pos++] == 1;
    }

    public byte readByte() {
        return this.buf[this.pos++];
    }

    public int readShort() {
        return (this.buf[this.pos++] & 0xFF) << 8 | this.buf[this.pos++] & 0xFF;
    }

    public int readInt() {
        return this.buf[this.pos++] << 24 | (this.buf[this.pos++] & 0xFF) << 16 | (this.buf[this.pos++] & 0xFF) << 8 | this.buf[this.pos++] & 0xFF;
    }

    public long readLong() {
        return (long)this.buf[this.pos++] << 56 | ((long)this.buf[this.pos++] & 0xFFL) << 48 | ((long)this.buf[this.pos++] & 0xFFL) << 40 | ((long)this.buf[this.pos++] & 0xFFL) << 32 | ((long)this.buf[this.pos++] & 0xFFL) << 24 | ((long)this.buf[this.pos++] & 0xFFL) << 16 | ((long)this.buf[this.pos++] & 0xFFL) << 8 | (long)this.buf[this.pos++] & 0xFFL;
    }

    public String readUTF() {
        int len = this.readInt();
        char[] b = new char[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (char)this.readInt();
        }
        return new String(b);
    }

    public void readByteArray(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readByte();
        }
    }

    public int size() {
        return this.buf.length;
    }
}

