/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.noop;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.impl.InternalStorageException;
import com.hazelcast.webmonitor.metrics.impl.MetricsRegistry;
import java.util.concurrent.atomic.AtomicInteger;

public class InMemoryMetricsRegistry
implements MetricsRegistry {
    private final Cache<MetricsRegistry.RegistryKey, MetricsRegistry.RegistryValue> cache;
    private final AtomicInteger metricsCounter = new AtomicInteger(0);
    private boolean closed;

    public InMemoryMetricsRegistry(int maxSize) {
        this.cache = Caffeine.newBuilder().maximumSize((long)maxSize).build();
    }

    public MetricsRegistry.RegistryValue get(MetricsRegistry.RegistryKey key) throws InternalStorageException.InternalClosedStoreException {
        if (key.isNil()) {
            throw new IllegalArgumentException("Registry key must not be nil");
        }
        this.ensureOpen();
        return (MetricsRegistry.RegistryValue)this.cache.getIfPresent((Object)key);
    }

    public MetricsRegistry.RegistryValue register(MetricsRegistry.RegistryKey key, DataPointType type) throws InternalStorageException.InternalClosedStoreException {
        this.ensureOpen();
        return (MetricsRegistry.RegistryValue)this.cache.get((Object)key, registryKey -> new MetricsRegistry.RegistryValue(this.metricsCounter.getAndIncrement(), type));
    }

    public int size() {
        if (this.closed) {
            return -1;
        }
        return (int)this.cache.estimatedSize();
    }

    public void close() {
        this.closed = true;
    }

    private void ensureOpen() throws InternalStorageException.InternalClosedStoreException {
        if (this.closed) {
            throw new InternalStorageException.InternalClosedStoreException("Store is already closed.");
        }
    }
}

