/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl;

import com.hazelcast.webmonitor.metrics.impl.InMemoryMinuteSeriesCache;
import com.hazelcast.webmonitor.metrics.impl.MinuteSeries;
import com.hazelcast.webmonitor.metrics.impl.MinuteStartId;
import com.hazelcast.webmonitor.metrics.impl.RawDataPoint;
import com.hazelcast.webmonitor.metrics.impl.utils.TimeUtil;
import com.hazelcast.webmonitor.metrics.impl.utils.ValueUtil;
import com.hazelcast.webmonitor.service.metrics.MetricsStorageStatsCounter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryCache
implements InMemoryMinuteSeriesCache,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryCache.class);
    private static final int METRICS_GC_RATE_MINUTES = 5;
    private static final int EXECUTOR_TERMINATION_TIMEOUT_MINUTES = 10;
    private final ConcurrentMap<Integer, MinuteSeries> store;
    private final ScheduledExecutorService danglingMetricsGC;

    public InMemoryCache(MetricsStorageStatsCounter statsCounter, int initialSize) {
        this.store = new ConcurrentHashMap(initialSize);
        this.danglingMetricsGC = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "DanglingMetricsGC"));
        this.danglingMetricsGC.scheduleAtFixedRate(() -> this.store.forEach((metricId, value) -> this.store.computeIfPresent(metricId, (k, v) -> {
            if (v.isEmpty()) {
                statsCounter.incrementEvictedDanglingMinuteSeries();
                return null;
            }
            return v;
        })), 5L, 5L, TimeUnit.MINUTES);
    }

    public MinuteSeries getMinuteSeries(int metricId) {
        return this.store.computeIfAbsent(metricId, MinuteSeries::new);
    }

    public long[] get(MinuteStartId minStartId) {
        MinuteSeries minuteSeries = (MinuteSeries)this.store.get(minStartId.getMetricId());
        if (minuteSeries == null) {
            return null;
        }
        return minuteSeries.findValues(minStartId.getTime());
    }

    public RawDataPoint getLatest(MinuteStartId minStartId, long endTime) {
        long[] values = this.get(minStartId);
        if (values != null) {
            for (int i = values.length - 1; i > -1; --i) {
                long time;
                long value = values[i];
                if (ValueUtil.isMissingValue((long)value) || (time = TimeUtil.minuteTimePoint((long)minStartId.getTime(), (int)i)) > endTime) continue;
                return new RawDataPoint(TimeUtil.minuteTimePoint((long)minStartId.getTime(), (int)i), value);
            }
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.danglingMetricsGC.shutdown();
            this.danglingMetricsGC.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.error("Could not close metrics in-memory cache.", (Throwable)e);
        }
    }

    void reset() {
        this.store.clear();
    }
}

