/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.MetricAware;
import com.hazelcast.webmonitor.metrics.Tags;
import com.hazelcast.webmonitor.metrics.impl.utils.MetricsUtil;
import java.io.Serializable;
import java.util.Objects;

public final class MetricDataPoint
implements MetricAware,
DataPointAware,
Serializable {
    private final String metric;
    private final Tags tags;
    private final long time;
    private final long value;
    private final DataPointType type;
    private final String unit;

    public MetricDataPoint(String metric, Tags tags, long time, long value) {
        this(metric, tags, time, value, DataPointType.LONG, null);
    }

    public MetricDataPoint(String metric, Tags tags, long time, long value, String unit) {
        this(metric, tags, time, value, DataPointType.LONG, unit);
    }

    public MetricDataPoint(String metric, Tags tags, long time, double value, String unit) {
        this(metric, tags, time, MetricsUtil.toInternalMetricValue((double)value), DataPointType.DOUBLE, unit);
    }

    private MetricDataPoint(String metric, Tags tags, long time, long value, DataPointType type, String unit) {
        this.metric = Objects.requireNonNull(metric, "Metric name must be set");
        this.tags = Objects.requireNonNull(tags, "Tags must be set");
        this.time = time;
        this.value = value;
        this.type = Objects.requireNonNull(type, "Type must be set");
        this.unit = unit;
    }

    public String getName() {
        return this.metric;
    }

    public Tags getTags() {
        return this.tags;
    }

    public long getTime() {
        return this.time;
    }

    public long getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        if (this.type == DataPointType.DOUBLE) {
            return MetricsUtil.toOriginalMetricValue((long)this.value);
        }
        throw new IllegalStateException("Double value is not supported for " + this.type + " type");
    }

    public DataPointType getType() {
        return this.type;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDataPoint that = (MetricDataPoint)o;
        return this.time == that.time && this.value == that.value && this.type == that.type && this.metric.equals(that.metric) && this.tags.equals((Object)that.tags) && Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        return Objects.hash(this.metric, this.tags, this.time, this.value, this.type, this.unit);
    }

    public String toString() {
        return "MetricDataPoint{metric='" + this.metric + '\'' + ", tags=" + this.tags + ", time=" + this.time + ", value=" + this.value + ", type=" + this.type + ", unit=" + this.unit + '}';
    }
}

