/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.events.model;

import com.hazelcast.internal.config.ConfigNamespace;
import com.hazelcast.internal.config.ConfigSections;
import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.internal.management.events.EventMetadata;
import com.hazelcast.webmonitor.events.EventVisitor;
import com.hazelcast.webmonitor.events.model.ConfigUpdateEvent;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public abstract class ConfigUpdateFinishedEvent
extends ConfigUpdateEvent {
    protected ConfigUpdateFinishedEvent(MemberIdentifier memberIdent, long timestamp, EventMetadata.EventType type, Map<String, Object> data) {
        super(memberIdent, timestamp, type, data);
    }

    public ConfigUpdateResult getConfigUpdateResult() {
        Map rawResult = (Map)this.data.get("configUpdateResult");
        Set added = ((List)rawResult.get("addedConfigs")).stream().map(arg_0 -> this.convertConfigNamespace(arg_0)).collect(Collectors.toSet());
        Set ignored = ((List)rawResult.get("ignoredConfigs")).stream().map(arg_0 -> this.convertConfigNamespace(arg_0)).collect(Collectors.toSet());
        return new ConfigUpdateResult(added, ignored);
    }

    private ConfigNamespace convertConfigNamespace(Map<String, Object> asMap) {
        String sectionName = (String)asMap.get("sectionName");
        ConfigSections section = Arrays.stream(ConfigSections.values()).filter(candidate -> sectionName.equals(candidate.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("config section %s not found", sectionName)));
        return new ConfigNamespace(section, Objects.toString(asMap.get("configName")));
    }

    public void accept(EventVisitor visitor) {
        visitor.visitConfigUpdateFinishedEvent(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ConfigUpdateFinishedEvent(super=" + super.toString() + ")";
    }
}

