/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.webmonitor.controller.internal.SwaggerUIConfigController;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import lombok.Generated;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(path={"/api"})
public class SwaggerUIConfigController {
    private static final String OPENAPI_DIR = "openapi";
    private final ServletContext servletContext;
    private final ResourcePatternResolver resolver;

    @GetMapping(value={"/swagger-ui/config"})
    public PartialSwaggerUIConfigDTO listOpenAPIDefinitionPaths() {
        List urls = this.listYamlFiles();
        return new PartialSwaggerUIConfigDTO(urls);
    }

    private List<OpenAPIDefinitionDTO> listYamlFiles() {
        return Arrays.stream(this.resolver.getResources("classpath:openapi/*.yaml")).map(arg_0 -> this.toDefinitionDTO(arg_0)).collect(Collectors.toList());
    }

    private OpenAPIDefinitionDTO toDefinitionDTO(Resource resource) {
        YamlMapping mapping = (YamlMapping)YamlLoader.load((InputStream)resource.getInputStream());
        String title = mapping.childAsMapping("info").childAsScalar("title").nodeValue().toString();
        String url = UriComponentsBuilder.fromPath((String)this.servletContext.getContextPath()).pathSegment(new String[]{OPENAPI_DIR}).pathSegment(new String[]{resource.getFilename()}).toUriString();
        return new OpenAPIDefinitionDTO(title, url);
    }

    @ConstructorProperties(value={"servletContext", "resolver"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SwaggerUIConfigController(ServletContext servletContext, ResourcePatternResolver resolver) {
        this.servletContext = servletContext;
        this.resolver = resolver;
    }
}

