/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.ExecuteScriptDTO;
import com.hazelcast.webmonitor.controller.dto.MemberScriptResultDTO;
import com.hazelcast.webmonitor.controller.dto.ScriptDTO;
import com.hazelcast.webmonitor.controller.exception.InvalidOperationApiException;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.model.hz.MemberScriptResult;
import com.hazelcast.webmonitor.model.sql.ScriptModel;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.ScriptManager;
import com.hazelcast.webmonitor.service.StateManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class ScriptController
extends BaseInternalController {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptController.class);
    private final ScriptManager scriptManager;
    private final MemberManager memberManager;

    public ScriptController(StateManager stateManager, ScriptManager scriptManager, MemberManager memberManager, AuditLogService auditService) {
        super(stateManager, auditService);
        this.scriptManager = scriptManager;
        this.memberManager = memberManager;
    }

    @GetMapping(value={"/scripts"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public List<String> getScripts() {
        return this.scriptManager.getScriptNames(this.currentUser());
    }

    @GetMapping(value={"/scripts/{script}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public ScriptDTO getScript(@PathVariable(name="script") String scriptName) {
        ScriptModel script = this.scriptManager.getScript(this.currentUser(), scriptName);
        return new ScriptDTO(script.getScriptName(), script.getLanguage(), script.getCode());
    }

    @PostMapping(value={"/scripts"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void saveScript(@Valid @RequestBody ScriptDTO scriptDTO, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.scriptManager.saveScript(this.currentUser(), scriptDTO);
    }

    @DeleteMapping(value={"/scripts/{script}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void deleteScript(@PathVariable String script) {
        this.scriptManager.deleteScript(this.currentUser(), script);
    }

    @PostMapping(value={"/scripts/execute"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public Collection<MemberScriptResultDTO> execute(@Valid @RequestBody ExecuteScriptDTO dto, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        List<String> targets = Arrays.asList(dto.getTargets().split(","));
        if (targets.isEmpty()) {
            throw new InvalidOperationApiException("Empty targets list.");
        }
        Collection response = this.memberManager.runScript(dto.getCluster(), new HashSet<String>(targets), dto.getLanguage(), dto.getCode());
        HashSet<MemberScriptResultDTO> result = new HashSet<MemberScriptResultDTO>();
        for (MemberScriptResult scriptResult : response) {
            if (!scriptResult.isSuccess()) {
                log.warn("Script execution error on {} : {}\nStack trace:\n{}", new Object[]{scriptResult.getAddress(), scriptResult.getResult(), scriptResult.getStackTrace()});
            }
            result.add(new MemberScriptResultDTO(scriptResult.getAddress(), scriptResult.isSuccess(), scriptResult.getResult()));
        }
        this.auditService.log(this.operationLogBuilder("MC-3001 [Script]", "Execute Script").parameter("cluster", (Object)dto.getCluster()).parameter("script", (Object)dto.getCode()).parameter("members", (Object)dto.getTargets()).build());
        return result;
    }
}

