/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.ConsoleCommandResultDTO;
import com.hazelcast.webmonitor.controller.dto.SlowOperationDTO;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.NoMemberApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.service.DeviceStatsManager;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.memberconfig.ParsedMemberConfig;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class MemberController
extends BaseInternalController {
    private final MemberManager memberManager;
    private final DeviceStatsManager deviceStatsManager;

    @Autowired
    public MemberController(StateManager stateManager, MemberManager memberManager, AuditLogService auditService, DeviceStatsManager deviceStatsManager) {
        super(stateManager, auditService);
        this.memberManager = memberManager;
        this.deviceStatsManager = deviceStatsManager;
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}/config"})
    public ParsedMemberConfig getConfig(@PathVariable String cluster, @PathVariable String member) {
        AllState clusterState = this.stateManager.getLatestState(cluster);
        if (clusterState == null) {
            throw new NoClusterApiException(cluster);
        }
        MemberState memberState = (MemberState)clusterState.getMemberStates().get(member);
        if (memberState == null) {
            throw new NoMemberApiException(member);
        }
        return this.memberManager.getParsedConfig(cluster, member);
    }

    @DeleteMapping(value={"/clusters/{cluster}/members/configs"})
    public void invalidateMemberConfigs(@PathVariable String cluster) {
        this.memberManager.reloadConfigCache(cluster);
    }

    @GetMapping(value={"/clusters/{cluster}/members/{member}/properties"})
    public Map<String, String> memberProperties(@PathVariable String cluster, @PathVariable String member) {
        return this.memberManager.getSystemProperties(cluster, member);
    }

    @GetMapping(path={"/clusters/{cluster}/members/{member}/deviceNames"})
    public SortedSet<String> deviceNames(@PathVariable String cluster, @PathVariable String member) {
        return this.deviceStatsManager.getDeviceNamesByMember(cluster, member);
    }

    @GetMapping(value={"/clusters/{cluster}/members/{member}/memberConfig"})
    public String memberConfig(@PathVariable String cluster, @PathVariable String member) {
        return this.memberManager.getConfig(cluster, member);
    }

    @GetMapping(value={"/clusters/{cluster}/members/{member}/slowOperations"})
    public List<SlowOperationDTO> memberSlowOperations(@PathVariable String cluster, @PathVariable String member) {
        return this.stateManager.getSlowOperationsList(cluster, member);
    }

    @GetMapping(path={"/clusters/{cluster}/members/config"})
    public Map<String, ParsedMemberConfig> getMembersConfig(@PathVariable(value="cluster") String cluster) {
        return this.memberManager.getAllMemberConfigs(cluster);
    }

    @PostMapping(path={"/clusters/{cluster}/members/{member}/execute"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public ConsoleCommandResultDTO executeCommand(@PathVariable String cluster, @PathVariable String member, @RequestParam String command, @RequestParam(required=false) String namespace) {
        String output = this.memberManager.runConsoleCommand(cluster, member, namespace, command);
        ConsoleCommandResultDTO result = new ConsoleCommandResultDTO(output);
        this.auditService.log(this.operationLogBuilder("MC-4001 [Console]", "Execute Console Command").parameter("cluster", (Object)cluster).parameter("command", (Object)command).parameter("member", (Object)member).build());
        return result;
    }

    @PostMapping(path={"/clusters/{cluster}/members/{member}/shutdown"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void shutdown(@PathVariable String cluster, @PathVariable String member) {
        this.executeOperation(() -> this.memberManager.shutdown(cluster, member), this.operationLogBuilder("MC-1005 [Cluster Config]", "Shutdown Member").parameter("cluster", (Object)cluster).parameter("member", (Object)member));
    }

    @PostMapping(path={"/clusters/{cluster}/members/{member}/promote"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void promoteLiteMember(@PathVariable String cluster, @PathVariable String member) {
        this.executeOperation(() -> this.memberManager.promoteLiteMember(cluster, member), this.operationLogBuilder("MC-1006 [Cluster Config]", "Promote Lite Member").parameter("cluster", (Object)cluster).parameter("member", (Object)member));
    }

    @PostMapping(path={"/clusters/{cluster}/members/{member}/threadDump"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public String threadDump(@PathVariable String cluster, @PathVariable String member) {
        return this.memberManager.getThreadDump(cluster, member, false);
    }

    @PostMapping(path={"/clusters/{cluster}/members/{member}/runGC"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void runGC(@PathVariable String cluster, @PathVariable String member) {
        this.memberManager.runGc(cluster, member);
    }
}

