/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.MapConfigDTO;
import com.hazelcast.webmonitor.controller.dto.MapDTO;
import com.hazelcast.webmonitor.controller.dto.MapThroughputStatsDTO;
import com.hazelcast.webmonitor.controller.dto.OperationThroughputStatsDTO;
import com.hazelcast.webmonitor.controller.dto.UpdateMapConfigDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientsNearCacheIntervalStatsDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.DataStructureStatsService;
import com.hazelcast.webmonitor.service.MapEntryViewDTO;
import com.hazelcast.webmonitor.service.MapManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.MCMapConfig;
import com.hazelcast.webmonitor.service.client.UpdateMapConfigParameters;
import java.util.List;
import java.util.SortedSet;
import javax.validation.Valid;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/api"})
public class MapController
extends BaseInternalController {
    private final MapManager mapManager;
    private final DataStructureStatsService statsService;

    public MapController(MapManager mapManager, DataStructureStatsService statsService, StateManager stateManager, AuditLogService auditService) {
        super(stateManager, auditService);
        this.mapManager = mapManager;
        this.statsService = statsService;
    }

    @GetMapping(path={"/clusters/{cluster}/maps/{map}/nearCache/clients/summaryStats"})
    public List<ClientsNearCacheIntervalStatsDTO> getMapClientsNearCacheSummaryStats(@PathVariable String cluster, @PathVariable String map, @RequestParam(defaultValue="0") long time) {
        return this.mapManager.getClientsNearCacheSummaryStats(cluster, map, time);
    }

    @GetMapping(path={"/clusters/{cluster}/maps/{map}/indexes"})
    public SortedSet<String> getMapIndexes(@PathVariable String cluster, @PathVariable String map) {
        return this.mapManager.getMapIndexes(cluster, map);
    }

    @GetMapping(value={"/clusters/{cluster}/maps/{map}/throughputStats"})
    public List<MapThroughputStatsDTO> getMapThroughputStats(@PathVariable String cluster, @PathVariable String map, @RequestParam(defaultValue="0") long time, @RequestParam(defaultValue="0") long interval) {
        return this.statsService.getMapThroughputStats(cluster, map, time, interval);
    }

    @GetMapping(value={"/clusters/{cluster}/replicatedMaps/{map}/throughputStats"})
    public List<OperationThroughputStatsDTO> getReplicatedMapThroughputStats(@PathVariable String cluster, @PathVariable String map, @RequestParam(defaultValue="0") long time, @RequestParam(defaultValue="0") long interval) {
        return this.statsService.getReplicatedMapThroughputStats(cluster, map, time, interval);
    }

    @GetMapping(value={"/clusters/{cluster}/multiMaps/{map}/throughputStats"})
    public List<OperationThroughputStatsDTO> getMultiMapThroughputStats(@PathVariable String cluster, @PathVariable String map, @RequestParam(defaultValue="0") long time, @RequestParam(defaultValue="0") long interval) {
        return this.statsService.getMultiMapThroughputStats(cluster, map, time, interval);
    }

    @GetMapping(value={"/clusters/{cluster}/maps"})
    public List<MapDTO> getMaps(@PathVariable String cluster) {
        return this.mapManager.getMaps(cluster);
    }

    @GetMapping(value={"/clusters/{cluster}/maps/{map}/config"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public MapConfigDTO getMapConfig(@PathVariable String cluster, @PathVariable String map) {
        MCMapConfig mapConfig = this.mapManager.getMapConfig(cluster, map);
        return MapController.toDto((MCMapConfig)mapConfig);
    }

    @GetMapping(value={"/clusters/{cluster}/maps/{map}/config/inMemoryFormat"})
    public String getMapInMemoryFormat(@PathVariable String cluster, @PathVariable String map) {
        return this.mapManager.getInMemoryFormat(cluster, map);
    }

    private static MapConfigDTO toDto(MCMapConfig mapConfig) {
        MapConfigDTO dto = new MapConfigDTO();
        dto.setMemoryFormat(mapConfig.getInMemoryFormat().name());
        dto.setBackupCount(mapConfig.getBackupCount());
        dto.setAsyncBackupCount(mapConfig.getAsyncBackupCount());
        dto.setTimeToLiveSeconds(mapConfig.getTimeToLiveSeconds());
        dto.setMaxIdleSeconds(mapConfig.getMaxIdleSeconds());
        dto.setMaxSize(mapConfig.getMaxSize());
        dto.setMaxSizePolicy(mapConfig.getMaxSizePolicy().name());
        dto.setReadBackupData(mapConfig.isReadBackupData());
        dto.setEvictionPolicy(mapConfig.getEvictionPolicy().name());
        dto.setMergePolicy(mapConfig.getMergePolicy());
        return dto;
    }

    @PostMapping(value={"/clusters/{cluster}/maps/{map}/config"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void updateMapConfig(@PathVariable String cluster, @PathVariable String map, @Valid @RequestBody UpdateMapConfigDTO dto, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        UpdateMapConfigParameters parameters = new UpdateMapConfigParameters(map, dto.getTimeToLiveSeconds(), dto.getMaxIdleSeconds(), dto.getEvictionPolicy(), dto.isReadBackupData(), dto.getMaxSize(), dto.getMaxSizePolicy());
        this.executeOperation(() -> this.mapManager.updateMapConfig(cluster, parameters), this.operationLogBuilder("MC-1001 [Cluster Config]", "Map Config Changed").parameter("username", (Object)this.currentUser()).parameter("cluster", (Object)cluster).parameter("map", (Object)map));
    }

    @GetMapping(value={"/clusters/{cluster}/maps/{map}/browse"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER", "ROLE_CLOUD_USER"})
    public MapEntryViewDTO browse(@PathVariable String cluster, @PathVariable String map, @RequestParam MapManager.MapKeyType keyType, @RequestParam String key) {
        return (MapEntryViewDTO)this.executeOperation(() -> this.mapManager.getMapEntry(cluster, map, keyType, key), this.operationLogBuilder("MC-5002 [Browser]", "Map was browsed by user").parameter("username", (Object)this.currentUser()).parameter("cluster", (Object)cluster).parameter("map", (Object)map).parameter("key", (Object)key));
    }

    @PostMapping(value={"/clusters/{cluster}/maps/{map}/clear"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void clear(@PathVariable String cluster, @PathVariable String map) {
        this.executeOperation(() -> this.mapManager.clearMap(cluster, map), this.operationLogBuilder("MC-5003 [Browser]", "Map was cleared by user").parameter("username", (Object)this.currentUser()).parameter("cluster", (Object)cluster).parameter("map", (Object)map));
    }
}

