/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.dto.client;

import com.hazelcast.internal.management.dto.ClientBwListDTO;
import com.hazelcast.internal.management.dto.ClientBwListEntryDTO;
import com.hazelcast.webmonitor.controller.dto.client.MemberClientFilteringListEntryDTO;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListEntryModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListType;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringMode;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringStatus;
import com.hazelcast.webmonitor.model.sql.client.DeployedClientFilteringConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class MemberClientFilteringListConfigDTO {
    private String eTag;
    private ClientFilteringMode mode;
    private List<MemberClientFilteringListEntryDTO> entries;

    public ClientBwListDTO toHazelcastDTO() {
        ClientBwListDTO.Mode memberModeEnum = this.mode.toImdgEnum();
        List memberEntries = this.entries.stream().map(localDTO -> new ClientBwListEntryDTO(localDTO.getType().getHazelcastType(), localDTO.getValue())).collect(Collectors.toList());
        return new ClientBwListDTO(memberModeEnum, memberEntries);
    }

    public static MemberClientFilteringListConfigDTO fromModel(DeployedClientFilteringConfig model) {
        ArrayList<MemberClientFilteringListEntryDTO> entries = new ArrayList<MemberClientFilteringListEntryDTO>();
        if (model.getEntries() != null) {
            for (ClientFilteringListEntryModel entryModel : model.getEntries()) {
                entries.add(MemberClientFilteringListEntryDTO.fromModel((ClientFilteringListEntryModel)entryModel));
            }
        }
        ClientFilteringMode mode = ClientFilteringMode.fromStatusAndType((ClientFilteringStatus)model.getStatus(), (ClientFilteringListType)model.getType());
        return new MemberClientFilteringListConfigDTO(model.getEtag(), mode, entries);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getETag() {
        return this.eTag;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientFilteringMode getMode() {
        return this.mode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<MemberClientFilteringListEntryDTO> getEntries() {
        return this.entries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMode(ClientFilteringMode mode) {
        this.mode = mode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEntries(List<MemberClientFilteringListEntryDTO> entries) {
        this.entries = entries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemberClientFilteringListConfigDTO)) {
            return false;
        }
        MemberClientFilteringListConfigDTO other = (MemberClientFilteringListConfigDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$eTag = this.getETag();
        String other$eTag = other.getETag();
        if (this$eTag == null ? other$eTag != null : !this$eTag.equals(other$eTag)) {
            return false;
        }
        ClientFilteringMode this$mode = this.getMode();
        ClientFilteringMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        List this$entries = this.getEntries();
        List other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemberClientFilteringListConfigDTO;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $eTag = this.getETag();
        result = result * 59 + ($eTag == null ? 43 : $eTag.hashCode());
        ClientFilteringMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        List $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MemberClientFilteringListConfigDTO(eTag=" + this.getETag() + ", mode=" + this.getMode() + ", entries=" + this.getEntries() + ")";
    }

    @ConstructorProperties(value={"eTag", "mode", "entries"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MemberClientFilteringListConfigDTO(String eTag, ClientFilteringMode mode, List<MemberClientFilteringListEntryDTO> entries) {
        this.eTag = eTag;
        this.mode = mode;
        this.entries = entries;
    }
}

