/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.configreplacer;

import com.hazelcast.webmonitor.configreplacer.AbstractPbeReplacer;
import java.io.ByteArrayOutputStream;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.util.ResourceUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EncryptionReplacer
extends AbstractPbeReplacer {
    public static final String PROPERTY_PASSWORD_USER_PROPERTIES = "hazelcast.mc.configReplacer.prop.passwordUserProperties";
    public static final String PROPERTY_PASSWORD_NETWORK_INTERFACE = "hazelcast.mc.configReplacer.prop.passwordNetworkInterface";
    public static final String PROPERTY_PASSWORD_FILE = "hazelcast.mc.configReplacer.prop.passwordFile";
    private static final String PREFIX = "ENC";
    static final int DEFAULT_ITERATIONS = 531;
    private boolean passwordUserProperties;
    private String passwordNetworkInterface;
    private String passwordFile;

    public void init(Properties properties) {
        super.init(properties);
        this.passwordFile = properties.getProperty("hazelcast.mc.configReplacer.prop.passwordFile");
        this.passwordUserProperties = Boolean.parseBoolean(properties.getProperty("hazelcast.mc.configReplacer.prop.passwordUserProperties", "true"));
        this.passwordNetworkInterface = properties.getProperty("hazelcast.mc.configReplacer.prop.passwordNetworkInterface");
        if (this.passwordFile == null && this.passwordNetworkInterface == null && !this.passwordUserProperties) {
            throw new IllegalArgumentException("At least one of the properties used to generate encryption password has to be configured");
        }
    }

    public String getPrefix() {
        return "ENC";
    }

    protected char[] getPassword() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.passwordFile != null) {
            baos.write(Files.readAllBytes(ResourceUtils.getFile((String)this.passwordFile).toPath()));
        }
        if (this.passwordUserProperties) {
            baos.write(System.getProperty("user.home").getBytes(StandardCharsets.UTF_8));
            baos.write(System.getProperty("user.name").getBytes(StandardCharsets.UTF_8));
        }
        if (this.passwordNetworkInterface != null) {
            NetworkInterface iface = NetworkInterface.getByName(this.passwordNetworkInterface);
            baos.write(iface.getHardwareAddress());
        }
        return new String(Base64.getEncoder().encode(baos.toByteArray()), StandardCharsets.UTF_8).toCharArray();
    }

    public static void main(String ... args) throws Exception {
        if (args == null || args.length < 1 || args.length > 2) {
            System.err.println("Usage:");
            System.err.println("\tjava -D<propertyName>=<propertyValue>  " + EncryptionReplacer.class.getName() + " \"<String To Encrypt>\" [iterations]");
            System.err.println();
            System.err.println("The replacer configuration can be provided directly via following property names:");
            System.err.println("\thazelcast.mc.configReplacer.prop.cipherAlgorithm");
            System.err.println("\thazelcast.mc.configReplacer.prop.keyLengthBits");
            System.err.println("\thazelcast.mc.configReplacer.prop.saltLengthBytes");
            System.err.println("\thazelcast.mc.configReplacer.prop.secretKeyAlgorithm");
            System.err.println("\thazelcast.mc.configReplacer.prop.secretKeyFactoryAlgorithm");
            System.err.println("\thazelcast.mc.configReplacer.prop.securityProvider");
            System.err.println("\thazelcast.mc.configReplacer.prop.passwordFile");
            System.err.println("\thazelcast.mc.configReplacer.prop.passwordNetworkInterface");
            System.err.println("\thazelcast.mc.configReplacer.prop.passwordUserProperties");
            System.err.println();
            System.err.println("Values available for property hazelcast.mc.configReplacer.prop.passwordNetworkInterface");
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] hardwareAddress = networkInterface.getHardwareAddress();
                if (hardwareAddress == null) continue;
                System.err.println("\t" + networkInterface.getName());
            }
            System.err.println();
            System.exit(1);
        }
        System.out.println(EncryptionReplacer.encrypt((String[])args));
    }

    private static String encrypt(String ... args) throws Exception {
        int iterations = args.length == 2 ? Integer.parseInt(args[1]) : 531;
        EncryptionReplacer replacer = new EncryptionReplacer();
        Properties properties = System.getProperties();
        replacer.init(properties);
        String encrypted = replacer.encrypt(args[0], iterations);
        return "$" + replacer.getPrefix() + "{" + encrypted + "}";
    }
}

