/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.PrometheusExporterConfigurationProperties;
import com.hazelcast.webmonitor.service.prometheus.PrometheusExporter;
import com.hazelcast.webmonitor.service.prometheus.PrometheusServlet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.servlet.Servlet;
import lombok.Generated;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
@ConditionalOnClass(value={Server.class, Loader.class, WebAppContext.class})
public class MCJettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<JettyServletWebServerFactory>,
Ordered {
    private static final List<String> TLS_PROTOCOLS = Arrays.asList("SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "SSLv2Hello");
    private final MCConfigurationProperties mcProperties;
    private final PrometheusExporterConfigurationProperties prometheusExporterProperties;
    private final ServerProperties serverProperties;
    private final PrometheusExporter prometheusExporter;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void customize(JettyServletWebServerFactory factory) {
        Integer prometheusExporterPort;
        factory.setUseForwardHeaders(this.mcProperties.isForwardedRequestsEnabled());
        MCConfigurationProperties.TLS tls = this.mcProperties.getTls();
        int mcPort = tls.isEnabled() ? this.mcProperties.getHttpsPort() : this.mcProperties.getHttpPort();
        InetSocketAddress address = new InetSocketAddress(this.mcProperties.getHostAddress(), mcPort);
        factory.setAddress(address.getAddress());
        factory.setPort(address.getPort());
        if (tls.isEnabled()) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{server -> this.addSSLConnector(address, server)});
            if (tls.isEnableHttpPort()) {
                factory.addServerCustomizers(new JettyServerCustomizer[]{server -> this.addSeparateHttpPortConnectorForMC(address, server)});
            }
            factory.addServerCustomizers(new JettyServerCustomizer[]{arg_0 -> this.addSecuredRedirectHandler(arg_0)});
        }
        if ((prometheusExporterPort = this.prometheusExporterProperties.getPort()) != null && !prometheusExporterPort.equals(mcPort)) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{arg_0 -> this.addSeparatePortConnectorForPrometheus(arg_0)});
        }
    }

    private void addSSLConnector(InetSocketAddress address, Server server) {
        ServerConnector connector = new ServerConnector(server, (SslContextFactory)this.createSslContextFactory());
        connector.setIdleTimeout(this.serverProperties.getJetty().getConnectionIdleTimeout().toMillis());
        connector.setPort(address.getPort());
        connector.setHost(address.getHostString());
        connector.setName("SecuredWebApp");
        server.setConnectors(new Connector[]{connector});
    }

    private void addSeparateHttpPortConnectorForMC(InetSocketAddress address, Server server) {
        HttpConfiguration config = new HttpConfiguration();
        config.setSecurePort(this.mcProperties.getHttpsPort());
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        connector.setIdleTimeout(this.serverProperties.getJetty().getConnectionIdleTimeout().toMillis());
        connector.setPort(this.mcProperties.getHttpPort());
        connector.setHost(address.getHostString());
        connector.setName("WebApp");
        server.addConnector((Connector)connector);
    }

    private void addSecuredRedirectHandler(Server server) {
        HandlerList handlerList = new HandlerList();
        handlerList.addHandler((Handler)new SecuredRedirectHandler());
        for (Handler handler : server.getHandlers()) {
            handlerList.addHandler(handler);
        }
        server.setHandler((Handler)handlerList);
    }

    private void addSeparatePortConnectorForPrometheus(Server server) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        HttpConnectionFactory connFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{connFactory});
        connector.setPort(this.prometheusExporterProperties.getPort().intValue());
        connector.setName("Prometheus");
        server.addConnector((Connector)connector);
        ServletHolder servletHolder = new ServletHolder((Servlet)new PrometheusServlet(this.prometheusExporter));
        ServletContextHandler contextHandler = new ServletContextHandler(0);
        contextHandler.setContextPath("/");
        contextHandler.addServlet(servletHolder, "/metrics");
        contextHandler.setVirtualHosts(new String[]{"@Prometheus"});
        HandlerList handlerList = new HandlerList();
        handlerList.addHandler((Handler)contextHandler);
        for (Handler handler : server.getHandlers()) {
            handlerList.addHandler(handler);
        }
        server.setHandler((Handler)handlerList);
    }

    public SslContextFactory.Server createSslContextFactory() {
        SslContextFactory.Server factory = new SslContextFactory.Server();
        MCConfigurationProperties.TLS tls = this.mcProperties.getTls();
        String keyStore = tls.getKeyStore();
        try {
            URL url = ResourceUtils.getURL((String)keyStore);
            factory.setKeyStoreResource(Resource.newResource((URL)url));
        }
        catch (Exception ex) {
            throw new WebServerException("Could not load key store '" + keyStore + "'", (Throwable)ex);
        }
        factory.setKeyStorePassword(tls.getKeyStorePassword());
        factory.setKeyManagerFactoryAlgorithm(tls.getKeyManagerAlgorithm());
        String trustStore = tls.getTrustStore();
        if (trustStore != null) {
            try {
                URL url = ResourceUtils.getURL((String)trustStore);
                factory.setTrustStoreResource(Resource.newResource((URL)url));
            }
            catch (Exception ex) {
                throw new WebServerException("Could not load trust store '" + trustStore + "'", (Throwable)ex);
            }
        }
        Optional.ofNullable(tls.getTrustStorePassword()).ifPresent(arg_0 -> ((SslContextFactory.Server)factory).setTrustStorePassword(arg_0));
        factory.setTrustManagerFactoryAlgorithm(tls.getTrustManagerAlgorithm());
        factory.setProtocol(tls.getProtocol());
        String mutualAuthentication = tls.getMutualAuthentication();
        if (mutualAuthentication != null) {
            if (mutualAuthentication.equals("REQUIRED")) {
                factory.setNeedClientAuth(true);
            } else if (mutualAuthentication.equals("OPTIONAL")) {
                factory.setWantClientAuth(true);
            }
        }
        if (!tls.getExcludeProtocols().isEmpty()) {
            List protocols = tls.getExcludeProtocols();
            String[] excludedProtocols = new String[protocols.size()];
            for (int i = 0; i < protocols.size(); ++i) {
                String excludedProtocol = ((String)protocols.get(i)).trim();
                if (!TLS_PROTOCOLS.contains(excludedProtocol)) {
                    throw new IllegalArgumentException("Excluded protocol [" + excludedProtocol + "] does not exist - no need to exclude it.");
                }
                excludedProtocols[i] = excludedProtocol;
            }
            factory.setExcludeProtocols(excludedProtocols);
        }
        if (tls.isOpenSsl()) {
            Security.addProvider((Provider)new OpenSSLProvider());
            factory.setProvider("Conscrypt");
        }
        Optional.ofNullable(this.mcProperties.getIncludeCipherSuites()).ifPresent(xva$0 -> factory.setIncludeCipherSuites(new String[]{xva$0}));
        Optional.ofNullable(this.mcProperties.getExcludeCipherSuites()).ifPresent(xva$0 -> factory.setExcludeCipherSuites(new String[]{xva$0}));
        return factory;
    }

    @ConstructorProperties(value={"mcProperties", "prometheusExporterProperties", "serverProperties", "prometheusExporter"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MCJettyWebServerFactoryCustomizer(MCConfigurationProperties mcProperties, PrometheusExporterConfigurationProperties prometheusExporterProperties, ServerProperties serverProperties, PrometheusExporter prometheusExporter) {
        this.mcProperties = mcProperties;
        this.prometheusExporterProperties = prometheusExporterProperties;
        this.serverProperties = serverProperties;
        this.prometheusExporter = prometheusExporter;
    }
}

