/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseUserTask;
import com.hazelcast.webmonitor.repositories.sql.AuthTokenDAO;
import com.hazelcast.webmonitor.repositories.sql.ScriptDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.UserCredentialsDAO;
import com.hazelcast.webmonitor.repositories.sql.UserDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DefaultSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.builtin.PasswordStrengthChecker;
import com.hazelcast.webmonitor.service.SettingsService;
import com.hazelcast.webmonitor.sql.JdbiHistories;
import java.io.PrintWriter;
import java.util.List;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Reset current security provider and delete all built-in user records in the default security provider.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
class ResetSecurityProviderTask
extends BaseUserTask {
    ResetSecurityProviderTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        SecurityConfigurationManager securityManager = new SecurityConfigurationManager(settingsDAO);
        securityManager.resetCurrentSecurityProviderName();
        this.deleteUsersFromDb(jdbi);
        this.printf("Successfully reset security provider.%n", new Object[0]);
        this.resetPrometheusAuth();
    }

    private void deleteUsersFromDb(Jdbi jdbi) {
        UserCredentialsDAO userCredentialsDAO = new UserCredentialsDAO(jdbi);
        DefaultSecurityProvider defaultSecurityProvider = new DefaultSecurityProvider(jdbi, new UserDAO(jdbi), userCredentialsDAO, new ScriptDAO(jdbi), new AuthTokenDAO(jdbi), new JdbiHistories(jdbi), new PasswordStrengthChecker());
        jdbi.useTransaction(handle -> {
            List usernames = userCredentialsDAO.getUsernamesTx(handle);
            usernames.forEach(username -> defaultSecurityProvider.deleteUserTx(handle, username));
        });
    }

    private void resetPrometheusAuth() {
        SettingsService settingsService = new SettingsService(new SettingsDAO(this.initJdbi()));
        if (settingsService.getPrometheusAuthDetails().isPresent()) {
            this.println("Successfully reset Prometheus scrape endpoint authentication.");
            settingsService.resetPrometheusAuthDetails();
        }
    }
}

