/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.repositories.sql.ClientFilteringDAO;
import com.hazelcast.webmonitor.repositories.sql.ClusterDAO;
import com.hazelcast.webmonitor.repositories.sql.ClusterRepository;
import com.hazelcast.webmonitor.repositories.sql.MemberDAO;
import com.hazelcast.webmonitor.sql.JdbiHistories;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.io.PrintWriter;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Remove Cluster Connection Config. *Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
public class RemoveClusterConfigTask
extends BaseCliTask {
    @CommandLine.Option(names={"-cn", "--cluster-name"}, paramLabel="<name>", description={"Cluster name."})
    private String clusterName;

    RemoveClusterConfigTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        if (StringUtil.isNullOrEmptyAfterTrim((String)this.clusterName)) {
            throw new CliException("Please provide cluster name to remove via -cn= or --cluster-name= option");
        }
        Jdbi jdbi = this.initJdbi();
        ClusterDAO clusterDAO = new ClusterDAO(jdbi);
        MemberDAO memberDAO = new MemberDAO(jdbi);
        ClientFilteringDAO clientFilteringDAO = new ClientFilteringDAO(jdbi);
        JdbiHistories histories = new JdbiHistories(jdbi);
        ClusterRepository clusterRepository = new ClusterRepository(clusterDAO, memberDAO, clientFilteringDAO, jdbi);
        histories.removeByCluster(this.clusterName);
        clusterRepository.remove(this.clusterName);
        this.printf("Successfully removed Cluster Config.%n", new Object[0]);
    }
}

