/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.ActiveDirectorySubCmd;
import com.hazelcast.webmonitor.cli.AddClusterConfigTask;
import com.hazelcast.webmonitor.cli.ClusterSubCmd;
import com.hazelcast.webmonitor.cli.ConfigureActiveDirectoryTask;
import com.hazelcast.webmonitor.cli.ConfigureDevModeTask;
import com.hazelcast.webmonitor.cli.ConfigureJaasTask;
import com.hazelcast.webmonitor.cli.ConfigureLdapTask;
import com.hazelcast.webmonitor.cli.ConfigureOidcTask;
import com.hazelcast.webmonitor.cli.ConfigureSamlTask;
import com.hazelcast.webmonitor.cli.CreateUserTask;
import com.hazelcast.webmonitor.cli.DevModeSubCmd;
import com.hazelcast.webmonitor.cli.IssueTokenTask;
import com.hazelcast.webmonitor.cli.JaasSubCmd;
import com.hazelcast.webmonitor.cli.LdapSubCmd;
import com.hazelcast.webmonitor.cli.ListConfiguredClustersTask;
import com.hazelcast.webmonitor.cli.MCConfCommandLine;
import com.hazelcast.webmonitor.cli.MetricsPersistenceSettingTask;
import com.hazelcast.webmonitor.cli.OidcSubCmd;
import com.hazelcast.webmonitor.cli.PrometheusAuthenticationSettingTask;
import com.hazelcast.webmonitor.cli.ReadConfigurationSubCmd;
import com.hazelcast.webmonitor.cli.ReadSettingsTask;
import com.hazelcast.webmonitor.cli.RemoveClusterConfigTask;
import com.hazelcast.webmonitor.cli.ResetSecurityProviderTask;
import com.hazelcast.webmonitor.cli.RevokeTokensTask;
import com.hazelcast.webmonitor.cli.SamlSubCmd;
import com.hazelcast.webmonitor.cli.SecuritySubCmd;
import com.hazelcast.webmonitor.cli.SensitivePropertiesSettingTask;
import com.hazelcast.webmonitor.cli.SettingSubCmd;
import com.hazelcast.webmonitor.cli.UpdateLdapPasswordTask;
import com.hazelcast.webmonitor.cli.UpdateUserPasswordTask;
import com.hazelcast.webmonitor.cli.UserSubCmd;
import com.hazelcast.webmonitor.config.properties.BuildInfo;
import com.hazelcast.webmonitor.environment.MCEnvironmentPostProcessor;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.springframework.boot.SpringApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;
import picocli.CommandLine;

/*
 * Exception performing whole class analysis ignored.
 */
@CommandLine.Command(name="mc-conf", description={"Command line tool for interacting with Hazelcast Management Center configuration.%n%nGlobal options are:"}, versionProvider=MCVersionProvider.class, mixinStandardHelpOptions=true, sortOptions=false, synopsisSubcommandLabel="COMMAND TASK")
public final class MCConfCommandLine
implements Runnable {
    @Override
    public void run() {
    }

    public static void main(String[] args) {
        MCConfCommandLine.silenceLogging();
        StandardEnvironment environment = new StandardEnvironment();
        new MCEnvironmentPostProcessor().postProcessEnvironment((ConfigurableEnvironment)environment, new SpringApplication(new Class[0]));
        MCConfCommandLine.runCommandLine((PrintWriter)new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8), true), (PrintWriter)new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8), true), (boolean)true, (String[])args, (ConfigurableEnvironment)environment);
    }

    private static void silenceLogging() {
        Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)Level.WARN);
    }

    static void revertSilenceLogging() {
        Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)Level.INFO);
    }

    public static int runCommandLine(PrintWriter out, PrintWriter err, boolean shouldExit, String[] args, ConfigurableEnvironment environment) {
        CommandLine cmd = new CommandLine((Object)new MCConfCommandLine()).addSubcommand("cluster", (Object)new CommandLine((Object)new ClusterSubCmd(out)).addSubcommand("add", (Object)new AddClusterConfigTask(out, environment)).addSubcommand("remove", (Object)new RemoveClusterConfigTask(out, environment)).addSubcommand("list", (Object)new ListConfiguredClustersTask(out, environment))).addSubcommand("user", (Object)new CommandLine((Object)new UserSubCmd(out)).addSubcommand("create", (Object)new CreateUserTask(out, environment)).addSubcommand("update-password", (Object)new UpdateUserPasswordTask(out, environment)).addSubcommand("issue-token", (Object)new IssueTokenTask(out, environment)).addSubcommand("revoke-tokens", (Object)new RevokeTokensTask(out, environment))).addSubcommand("ldap", (Object)new CommandLine((Object)new LdapSubCmd(out)).addSubcommand("configure", (Object)new ConfigureLdapTask(out, environment)).addSubcommand("update-password", (Object)new UpdateLdapPasswordTask(out, environment))).addSubcommand("active-directory", (Object)new CommandLine((Object)new ActiveDirectorySubCmd(out)).addSubcommand("configure", (Object)new ConfigureActiveDirectoryTask(out, environment))).addSubcommand("jaas", (Object)new CommandLine((Object)new JaasSubCmd(out)).addSubcommand("configure", (Object)new ConfigureJaasTask(out, environment))).addSubcommand("oidc", (Object)new CommandLine((Object)new OidcSubCmd(out)).addSubcommand("configure", (Object)new ConfigureOidcTask(out, environment))).addSubcommand("saml", (Object)new CommandLine((Object)new SamlSubCmd(out)).addSubcommand("configure", (Object)new ConfigureSamlTask(out, environment))).addSubcommand("security", (Object)new CommandLine((Object)new SecuritySubCmd(out)).addSubcommand("reset", (Object)new ResetSecurityProviderTask(out, environment))).addSubcommand("set", (Object)new CommandLine((Object)new SettingSubCmd(out)).addSubcommand("metrics-persistence-enabled", (Object)new MetricsPersistenceSettingTask(out, environment)).addSubcommand("sensitive-properties", (Object)new SensitivePropertiesSettingTask(out, environment)).addSubcommand("prometheus-auth", (Object)new PrometheusAuthenticationSettingTask(out, environment))).addSubcommand("get", (Object)new CommandLine((Object)new ReadConfigurationSubCmd(out)).addSubcommand("settings", (Object)new ReadSettingsTask(out, environment))).addSubcommand("dev-mode", (Object)new CommandLine((Object)new DevModeSubCmd(out)).addSubcommand("configure", (Object)new ConfigureDevModeTask(out, environment))).setCaseInsensitiveEnumValuesAllowed(true);
        String mcVersion = BuildInfo.getFullVersion();
        cmd.getCommandSpec().usageMessage().header(new String[]{"Hazelcast Management Center Configuration Tool " + mcVersion});
        if (args.length == 0) {
            cmd.usage(out);
            return 0;
        }
        cmd.setOut(out).setErr(err).setColorScheme(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO)).setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new MCConfExceptionHandler());
        int exitCode = cmd.execute(args);
        if (shouldExit) {
            System.exit(exitCode);
        }
        return exitCode;
    }
}

