/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.GroupsToRolesMappingOptions;
import com.hazelcast.webmonitor.security.spi.impl.ldap.LdapConfig;
import com.hazelcast.webmonitor.utils.StringUtil;
import picocli.CommandLine;

class LdapOptions {
    @CommandLine.Option(names={"-u", "--url"}, required=true, paramLabel="<ldap instance>", description={"Url to the LDAP instance."})
    private String url;
    @CommandLine.Option(names={"-ln", "--ldap-username"}, required=true, description={"Username used to authenticate to LDAP instance."})
    private String username;
    @CommandLine.Option(names={"-lp", "--ldap-password"}, paramLabel="<password>", description={"LDAP password used to authenticate to LDAP instance. Provide value directly or use without value to enter securely with interactive prompt."}, arity="0..1", interactive=true)
    private String ldapPassword;
    @CommandLine.Option(names={"-ud", "--user-dn"}, required=true, description={"User DN that you want to use to search for users."})
    private String userDn;
    @CommandLine.Option(names={"-gd", "--group-dn"}, required=true, description={"Group DN that you want to use to search for groups."})
    private String groupDn;
    @CommandLine.Option(names={"-usf", "--user-search-filter"}, required=true, description={"LDAP search filter expression to search for the users."})
    private String userSearchFilter;
    @CommandLine.Option(names={"-gsf", "--group-search-filter"}, required=true, description={"LDAP search filter expression to search for the groups."})
    private String groupSearchFilter;
    @CommandLine.Option(names={"-st", "--start-tls"}, description={"Enables communication over TLS with LDAP instance."})
    private boolean startTls;
    @CommandLine.Option(names={"-ngs", "--nested-group-search"}, defaultValue="true", description={"Enables nested group search."})
    private boolean nestedGroupSearch;
    @CommandLine.Mixin
    private GroupsToRolesMappingOptions rolesOptions;

    LdapOptions() {
    }

    void validate() {
        if (StringUtil.isNullOrEmptyAfterTrim((String)this.ldapPassword)) {
            throw new CliException("LDAP password parameter is not specified. Use --ldap-password=<password> or --ldap-password without value to enter it with interactive prompt.");
        }
    }

    LdapConfig ldapConfig() {
        return LdapConfig.builder().url(this.url).username(this.username).password(this.ldapPassword).userDn(this.userDn).groupDn(this.groupDn).userSearchFilter(this.userSearchFilter).groupSearchFilter(this.groupSearchFilter).startTls(this.startTls).nestedGroupSearch(this.nestedGroupSearch).groupsToRolesMappingConfig(this.rolesOptions.toConfig()).build();
    }
}

