/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.cli.GroupsToRolesMappingOptions;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.activedirectory.ActiveDirectoryConfig;
import com.hazelcast.webmonitor.security.spi.impl.activedirectory.PersistentActiveDirectoryConfig;
import java.io.PrintWriter;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Configure Active Directory Security Provider. No Security Provider should be already configured when using this task. If you need to overwrite security provider configuration, use 'security reset' task first.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
class ConfigureActiveDirectoryTask
extends BaseCliTask {
    @CommandLine.Mixin
    private GroupsToRolesMappingOptions groupsToRolesMappingOptions;
    @CommandLine.Option(names={"-u", "--url"}, required=true, paramLabel="<Active Directory url>", description={"URL of Active Directory instance."})
    private String url;
    @CommandLine.Option(names={"-d", "--domain"}, required=true, paramLabel="<Active Directory Domain>", description={"Active Directory Domain."})
    private String domain;
    @CommandLine.Option(names={"-usf", "--user-search-filter"}, required=true, description={"LDAP search filter expression to search for the users."})
    private String userSearchFilter;
    @CommandLine.Option(names={"-ngs", "--nested-group-search"}, description={"Enables nested group search."})
    private boolean nestedGroupSearch;

    ConfigureActiveDirectoryTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        SecurityConfigurationManager securityManager = new SecurityConfigurationManager(settingsDAO);
        if (securityManager.getCurrentSecurityProviderName() != null) {
            throw new CliException("Security Provider is already configured. Use 'security reset' task first, if you want to set up new security provider.");
        }
        GroupedSettingsDAO groupedSettingsDAO = new GroupedSettingsDAO(jdbi, settingsDAO);
        PersistentActiveDirectoryConfig persistentConfig = new PersistentActiveDirectoryConfig(groupedSettingsDAO);
        persistentConfig.write((SecurityProviderConfig)this.activeDirectoryConfig());
        securityManager.setCurrentSecurityProviderName("Active Directory");
        this.printf("Successfully set up Active Directory security provider.%n", new Object[0]);
    }

    private ActiveDirectoryConfig activeDirectoryConfig() {
        return ActiveDirectoryConfig.builder().url(this.url).domain(this.domain).userSearchFilter(this.userSearchFilter).nestedGroupSearch(this.nestedGroupSearch).groupsToRolesMappingConfig(this.groupsToRolesMappingOptions.toConfig()).build();
    }
}

