/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.connector;

import com.hazelcast.connector.WriteMapP;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.spi.annotation.Beta;
import java.util.Map;
import javax.annotation.Nonnull;

@Beta
public final class Hz3Sinks {
    private Hz3Sinks() {
    }

    @Beta
    @Nonnull
    public static <K, V> Sink<Map.Entry<K, V>> remoteMap(@Nonnull String mapName, @Nonnull String clientXml) {
        return Hz3Sinks.remoteMap(mapName, Map.Entry::getKey, Map.Entry::getValue, clientXml);
    }

    @Beta
    @Nonnull
    public static <T, K, V> Sink<T> remoteMap(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull String clientXml) {
        return new SinkImpl("mapSink(" + mapName + ')', Hz3Sinks.writeRemoteMapP(mapName, toKeyFn, toValueFn, clientXml), toKeyFn);
    }

    @Nonnull
    static <T, K, V> ProcessorMetaSupplier writeRemoteMapP(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull String clientXml) {
        return ProcessorMetaSupplier.preferLocalParallelismOne(new WriteMapP.Supplier<T, K, V>(clientXml, mapName, toKeyFn, toValueFn));
    }
}

