/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.grpc.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.grpc.GrpcProperties;
import com.hazelcast.jet.grpc.GrpcService;
import com.hazelcast.jet.grpc.impl.GrpcUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class BidirectionalStreamingService<T, R>
implements GrpcService<T, R> {
    private final StreamObserver<T> sink;
    private final Queue<CompletableFuture<R>> futureQueue = new ConcurrentLinkedQueue<CompletableFuture<R>>();
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final ILogger logger;
    private final ManagedChannel channel;
    private volatile Throwable exceptionInOutputObserver;
    private final long destroyTimeout;
    private final long shutdownTimeout;

    public BidirectionalStreamingService(@Nonnull Processor.Context context, @Nonnull ManagedChannel channel, @Nonnull FunctionEx<? super ManagedChannel, ? extends FunctionEx<StreamObserver<R>, StreamObserver<T>>> callStubFn) {
        this.logger = context.logger();
        this.channel = channel;
        this.sink = (StreamObserver)((FunctionEx)callStubFn.apply((Object)channel)).apply((Object)new OutputMessageObserver());
        Properties properties = context.hazelcastInstance().getConfig().getProperties();
        HazelcastProperties hzProperties = new HazelcastProperties(properties);
        this.destroyTimeout = hzProperties.getSeconds(GrpcProperties.DESTROY_TIMEOUT);
        this.shutdownTimeout = hzProperties.getSeconds(GrpcProperties.SHUTDOWN_TIMEOUT);
    }

    @Override
    @Nonnull
    public CompletableFuture<R> call(@Nonnull T input) {
        this.checkForServerError();
        CompletableFuture future = new CompletableFuture();
        this.futureQueue.add(future);
        this.sink.onNext(input);
        return future;
    }

    private void checkForServerError() {
        if (this.completionLatch.getCount() == 0L) {
            throw new JetException("Exception in gRPC service: " + this.exceptionInOutputObserver, this.exceptionInOutputObserver);
        }
    }

    public void destroy() throws InterruptedException {
        this.sink.onCompleted();
        if (!this.completionLatch.await(this.destroyTimeout, TimeUnit.SECONDS)) {
            this.logger.info("gRPC call has not completed on time");
        }
        GrpcUtil.shutdownChannel(this.channel, this.logger, this.shutdownTimeout);
    }

    private class OutputMessageObserver
    implements StreamObserver<R> {
        private OutputMessageObserver() {
        }

        @Override
        public void onNext(R outputItem) {
            try {
                ((CompletableFuture)BidirectionalStreamingService.this.futureQueue.remove()).complete(outputItem);
            }
            catch (Throwable e) {
                BidirectionalStreamingService.this.exceptionInOutputObserver = e;
                BidirectionalStreamingService.this.completionLatch.countDown();
            }
        }

        @Override
        public void onError(Throwable e) {
            try {
                CompletableFuture future;
                e = GrpcUtil.translateGrpcException(e);
                BidirectionalStreamingService.this.exceptionInOutputObserver = e;
                while ((future = (CompletableFuture)BidirectionalStreamingService.this.futureQueue.poll()) != null) {
                    future.completeExceptionally(e);
                }
            }
            finally {
                BidirectionalStreamingService.this.completionLatch.countDown();
            }
        }

        @Override
        public void onCompleted() {
            CompletableFuture future;
            while ((future = (CompletableFuture)BidirectionalStreamingService.this.futureQueue.poll()) != null) {
                future.completeExceptionally(new JetException("Completion signaled before the future was completed"));
            }
            BidirectionalStreamingService.this.completionLatch.countDown();
        }
    }
}

