/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.getters.CompactGetter;
import com.hazelcast.query.impl.getters.PortableGetter;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;

public class FieldAccessExpression<T>
implements Expression<T>,
IdentifiedDataSerializable {
    private QueryDataType type;
    private String name;
    private Expression<?> ref;

    public FieldAccessExpression() {
    }

    private FieldAccessExpression(QueryDataType type, String name, Expression<?> ref) {
        this.type = type;
        this.name = name;
        this.ref = ref;
    }

    public static FieldAccessExpression<?> create(QueryDataType type, String name, Expression<?> ref) {
        return new FieldAccessExpression(type, name, ref);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object res = this.ref.eval(row, context);
        if (res == null) {
            return null;
        }
        if (this.isPrimitive(res.getClass())) {
            throw QueryException.error("Field Access expression can not be applied to primitive types");
        }
        try {
            if (res instanceof PortableGenericRecord) {
                return (T)this.type.convert(this.extractPortableField((PortableGenericRecord)res, this.name, context.getSerializationService()));
            }
            if (res instanceof CompactGenericRecord) {
                return (T)this.type.convert(this.extractCompactField((CompactGenericRecord)res, this.name, context.getSerializationService()));
            }
            return (T)this.type.convert(ReflectionUtils.getFieldValue(this.name, res));
        }
        catch (Exception e) {
            throw QueryException.error("Failed to extract field");
        }
    }

    private Object extractPortableField(PortableGenericRecord portable, String name, InternalSerializationService ss) {
        PortableGetter getter = new PortableGetter(ss);
        try {
            return getter.getValue(portable, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object extractCompactField(CompactGenericRecord compact, String name, InternalSerializationService ss) {
        CompactGetter getter = new CompactGetter(ss);
        try {
            return getter.getValue(compact, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isPrimitive(Class<?> clazz) {
        return clazz.getPackage().getName().startsWith("java.");
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 62;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.type);
        out.writeString(this.name);
        out.writeObject(this.ref);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.type = (QueryDataType)in.readObject();
        this.name = in.readString();
        this.ref = (Expression)in.readObject();
    }

    @Override
    public QueryDataType getType() {
        return this.type;
    }
}

