/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl.weaksecretrules;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.impl.SecretStrengthRule;
import com.hazelcast.security.impl.WeakSecretError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EnumSet;

public class DictionaryRule
implements SecretStrengthRule {
    private static final String CUSTOM_WORD_LIST_PATH_PROPERTY = "hazelcast.security.dictionary.policy.wordlist.path";
    private static final String DEFAULT_WORD_LIST_PATH = "/usr/share/dict/words";
    private final ILogger logger = Logger.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumSet<WeakSecretError> check(CharSequence secret) {
        String wordListPath = System.getProperty(CUSTOM_WORD_LIST_PATH_PROPERTY, DEFAULT_WORD_LIST_PATH);
        File wordList = new File(wordListPath);
        if (!wordList.exists()) {
            this.logger.warning("Dictionary secret policy disabled, word-list file <" + wordListPath + "> not found.");
            return EnumSet.noneOf(WeakSecretError.class);
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(wordListPath)), "UTF-8"));
            while ((line = br.readLine()) != null) {
                if (!line.equals(secret)) continue;
                EnumSet<WeakSecretError> enumSet = EnumSet.of(WeakSecretError.DICT_WORD);
                IOUtil.closeResource(br);
                return enumSet;
            }
            IOUtil.closeResource(br);
        }
        catch (IOException e) {
            ExceptionUtil.sneakyThrow(e);
        }
        finally {
            IOUtil.closeResource(br);
        }
        return EnumSet.noneOf(WeakSecretError.class);
    }

    public static boolean isAvailable() {
        String wordListPath = System.getProperty(CUSTOM_WORD_LIST_PATH_PROPERTY, DEFAULT_WORD_LIST_PATH);
        return new File(wordListPath).exists();
    }
}

