/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.PermissionConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.management.operation.UpdatePermissionConfigOperation;
import com.hazelcast.internal.services.CoreService;
import com.hazelcast.internal.services.PreJoinAwareService;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.security.SecurityService;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class SecurityServiceImpl
implements SecurityService,
CoreService,
PreJoinAwareService<UpdatePermissionConfigOperation> {
    public static final String SERVICE_NAME = "hz:ee:securityServiceImpl";
    private static final int RETRY_COUNT = 3;
    private Node node;
    private volatile Set<PermissionConfig> permissionConfigs;

    public SecurityServiceImpl(Node node) {
        this.node = node;
        this.permissionConfigs = SecurityServiceImpl.clonePermissionConfigs(node.getConfig().getSecurityConfig().getClientPermissionConfigs());
    }

    @Override
    public void refreshClientPermissions(Set<PermissionConfig> permissionConfigs) {
        Set<PermissionConfig> clonedConfigs = SecurityServiceImpl.clonePermissionConfigs(permissionConfigs);
        UpdatePermissionConfigOperationSupplier supplier = new UpdatePermissionConfigOperationSupplier(clonedConfigs);
        InternalCompletableFuture future = InvocationUtil.invokeOnStableClusterSerial(this.node.nodeEngine, supplier, 3);
        future.joinInternal();
    }

    public static Set<PermissionConfig> clonePermissionConfigs(Set<PermissionConfig> permissionConfigs) {
        HashSet<PermissionConfig> clonedConfigs = new HashSet<PermissionConfig>();
        for (PermissionConfig permissionConfig : permissionConfigs) {
            clonedConfigs.add(new PermissionConfig(permissionConfig));
        }
        return clonedConfigs;
    }

    @Override
    public Set<PermissionConfig> getClientPermissionConfigs() {
        return this.permissionConfigs;
    }

    public void setPermissionConfigs(Set<PermissionConfig> permissionConfigs) {
        this.permissionConfigs = permissionConfigs;
    }

    @Override
    public UpdatePermissionConfigOperation getPreJoinOperation() {
        return new UpdatePermissionConfigOperation(this.permissionConfigs);
    }

    public static class UpdatePermissionConfigOperationSupplier
    implements Supplier<Operation> {
        private Set<PermissionConfig> permissionConfigs;

        public UpdatePermissionConfigOperationSupplier(Set<PermissionConfig> permissionConfigs) {
            this.permissionConfigs = permissionConfigs;
        }

        @Override
        public Operation get() {
            return new UpdatePermissionConfigOperation(this.permissionConfigs);
        }
    }
}

