/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.security.Parameters;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ParametersImpl
implements Parameters {
    private final SerializationService serializationService;
    private Object[] args;

    public ParametersImpl(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setArgs(Object[] args) {
        this.args = args;
    }

    @Override
    public int length() {
        return this.args.length;
    }

    @Override
    public Object get(int index) {
        this.args[index] = this.serializationService.toObject(this.args[index]);
        this.checkCollection(index);
        return this.args[index];
    }

    public Iterator iterator() {
        return new Iterator(){
            int index = -1;

            @Override
            public boolean hasNext() {
                return ParametersImpl.this.args.length > this.index + 1;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.index;
                return ParametersImpl.this.get(this.index);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Arguments are read-only!");
            }
        };
    }

    private void checkCollection(int index) {
        AbstractCollection collection;
        Object arg = this.args[index];
        if (!(arg instanceof Collection)) {
            this.checkMap(index);
            return;
        }
        if (arg instanceof Set) {
            collection = new HashSet();
        } else if (arg instanceof List) {
            collection = new ArrayList(((List)arg).size());
        } else {
            throw new IllegalArgumentException("Collection[" + arg + "] is unknown!!!");
        }
        for (Object o : (Collection)arg) {
            collection.add(this.serializationService.toObject(o));
        }
        this.args[index] = collection;
    }

    private void checkMap(int index) {
        Object arg = this.args[index];
        if (arg instanceof Map) {
            Map argMap = (Map)arg;
            HashMap objectMap = new HashMap();
            for (Map.Entry entry : argMap.entrySet()) {
                Object key = this.serializationService.toObject(entry.getKey());
                Object val = this.serializationService.toObject(entry.getValue());
                objectMap.put(key, val);
            }
            this.args[index] = objectMap;
        }
    }
}

