/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.hidensity.impl.TieredStoreRecordProcessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.TieredStoreUser;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.mapstore.MapDataStores;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordFactory;
import com.hazelcast.map.impl.recordstore.EnterpriseBaseRecordStore;
import com.hazelcast.map.impl.recordstore.JsonMetadataStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.TieredStorageImpl;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.wan.impl.CallerProvenance;
import java.util.UUID;
import javax.annotation.Nonnull;

public class EnterpriseTieredRecordStore
extends EnterpriseBaseRecordStore {
    private final TieredStoreService tieredStoreService;

    public EnterpriseTieredRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader, ILogger logger) {
        super(mapContainer, partitionId, keyLoader, logger);
        Node node = ((NodeEngineImpl)this.mapServiceContext.getNodeEngine()).getNode();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)node.getNodeExtension();
        this.tieredStoreService = nodeExtension.getTieredStoreService();
    }

    @Override
    protected JsonMetadataStore createMetadataStore() {
        return JsonMetadataStore.NULL;
    }

    @Override
    public void init() {
        super.init();
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)this.mapServiceContext.getPartitionContainer(this.partitionId);
        partitionContainer.getOrCreateHybridLogReference(this.mapContainer.getName());
    }

    @Override
    public EvictionPolicy getEvictionPolicy() {
        return EvictionPolicy.NONE;
    }

    @Override
    @Nonnull
    protected ExpirySystem createExpirySystem(MapContainer mapContainer) {
        return ExpirySystem.NULL;
    }

    @Override
    public Storage createStorage(RecordFactory recordFactory, InMemoryFormat memoryFormat) {
        EnterpriseMapServiceContext mapServiceContext = (EnterpriseMapServiceContext)this.mapContainer.getMapServiceContext();
        assert (InMemoryFormat.NATIVE == this.inMemoryFormat);
        TieredStoreRecordFactory tieredStoreRecordFactory = (TieredStoreRecordFactory)recordFactory;
        NodeEngineImpl nodeEngine = (NodeEngineImpl)mapServiceContext.getNodeEngine();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)nodeEngine.getNode().getNodeExtension();
        TieredStoreService tieredStoreService = nodeExtension.getTieredStoreService();
        Epoch epoch = tieredStoreService.epoch();
        String deviceName = this.mapContainer.getMapConfig().getTieredStoreConfig().getDiskTierConfig().getDeviceName();
        return new TieredStorageImpl(new TStoreUserId(TieredStoreUser.IMAP, this.name), this.partitionId, tieredStoreRecordFactory, epoch, this.memoryManager, tieredStoreService.compactionManager(deviceName), this.statsEnabled);
    }

    @Override
    public TieredStoreRecord createRecord(Data key, Object value, long now) {
        return (TieredStoreRecord)super.createRecord(key, value, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Record putNewRecord(Data key, Object oldValue, Object newValue, long ttl, long maxIdle, long expiryTime, long now, UUID transactionId, EntryEventType entryEventType, boolean store, boolean backup) {
        assert (this.mapDataStore == MapDataStores.EMPTY_MAP_DATA_STORE);
        assert (entryEventType != EntryEventType.LOADED);
        assert (this.expirySystem == ExpirySystem.NULL);
        TieredStoreRecord record = this.createRecord(key, newValue, now);
        boolean pinned = record.pin();
        assert (pinned);
        try {
            this.storage.put(key, record);
            this.lockKey(key);
            this.mutationObserver.onPutRecord(key, record, oldValue, backup);
            TieredStoreRecord tieredStoreRecord = record;
            return tieredStoreRecord;
        }
        finally {
            this.unlockKey(key, false);
            record.unpin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record putOrUpdateReplicatedRecord(Data dataKey, Record replicatedRecord, ExpiryMetadata expiryMetadata, boolean indexesMustBePopulated, long now) {
        assert (this.expirySystem == ExpirySystem.NULL);
        TieredStoreRecord newRecord = (TieredStoreRecord)this.storage.get(dataKey);
        boolean pinnedNewRecord = false;
        try {
            if (newRecord == null) {
                newRecord = this.createRecord(dataKey, replicatedRecord != null ? replicatedRecord.getValue() : null, now);
                pinnedNewRecord = newRecord.pin();
                assert (pinnedNewRecord);
                this.storage.put(dataKey, newRecord);
                this.lockKey(dataKey);
            } else {
                this.lockKey(dataKey);
                newRecord = this.storage.updateRecordValue(dataKey, newRecord, replicatedRecord.getValue());
                pinnedNewRecord = newRecord.pin();
            }
            Records.copyMetadataFrom(replicatedRecord, newRecord);
            this.mutationObserver.onReplicationPutRecord(dataKey, newRecord, indexesMustBePopulated);
            TieredStoreRecord tieredStoreRecord = newRecord;
            return tieredStoreRecord;
        }
        finally {
            this.unlockKey(dataKey, false);
            if (pinnedNewRecord) {
                newRecord.unpin();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object updateRecord(Record record, Data key, Object oldValue, Object newValue, boolean changeExpiryOnUpdate, long ttl, long maxIdle, long expiryTime, long now, UUID transactionId, boolean store, boolean countAsAccess, boolean backup) {
        assert (this.mapDataStore == MapDataStores.EMPTY_MAP_DATA_STORE);
        Data oldValueHeapData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        this.updateStatsOnPut(countAsAccess, now);
        record.onUpdate(now);
        if (countAsAccess) {
            record.onAccess(now);
        }
        this.lockKey(key);
        try {
            TieredStoreRecord newRecord = (TieredStoreRecord)this.storage.updateRecordValue(key, record, newValueData);
            boolean pinned = newRecord.pin();
            assert (pinned);
            try {
                if (changeExpiryOnUpdate) {
                    this.expirySystem.add(key, ttl, maxIdle, expiryTime, now, now);
                }
                this.mutationObserver.onUpdateRecord(key, newRecord, oldValueHeapData, newValueData, backup);
                Data data = oldValueHeapData;
                newRecord.unpin();
                return data;
            }
            catch (Throwable throwable) {
                newRecord.unpin();
                throw throwable;
            }
        }
        finally {
            this.unlockKey(key, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object removeRecord(Data key, @Nonnull Record record, long now, CallerProvenance provenance, UUID transactionId) {
        this.lockKey(key);
        try {
            Object object = super.removeRecord(key, record, now, provenance, transactionId);
            return object;
        }
        finally {
            this.unlockKey(key, true);
        }
    }

    @Override
    public void removeReplicatedRecord(Data key, boolean backup) {
        this.lockKey(key);
        try {
            super.removeReplicatedRecord(key, backup);
        }
        finally {
            this.unlockKey(key, true);
        }
    }

    @Override
    public TieredStorageImpl getStorage() {
        return (TieredStorageImpl)super.getStorage();
    }

    public State getState() {
        return this.getStorage().getState();
    }

    public Index getIndex() {
        return this.getStorage().getIndex();
    }

    public TieredStoreRecordProcessor getRecordProcessor() {
        return this.getStorage().getRecordProcessor();
    }

    private void lockKey(Data key) {
        int threadIndex = this.tieredStoreService.epoch().getCurrentThreadIndex();
        boolean locked = this.getStorage().getIndex().lock(threadIndex, key);
        assert (locked);
    }

    private void unlockKey(Data key, boolean remove) {
        this.getStorage().getIndex().unlock(key, remove);
    }
}

